<?php


class bt_bb_floating_element extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts', array(
			'background_image'      		=> '',
			'background_color'				=> '',
			'inline_css_style'      		=> '',
			'horizontal_position'  			=> 'left',
			'vertical_position'  			=> 'top',
			'animation_style'  				=> 'ease_out',
			'animation_delay'  				=> 'default',
			'animation_duration'  			=> '',
			'animation_speed'  				=> '1.0',
			'lazy_load'  					=> 'no'
		) ), $atts, $this->shortcode ) );
		
		wp_enqueue_script(
			'bt_bb_floating_element',
			get_template_directory_uri() . '/bold-page-builder/content_elements/bt_bb_floating_element/bt_bb_floating_element.js',
			array( 'jquery' ),
			'',
			true
		);
		
		$class = array( $this->shortcode );

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}
		if ( $horizontal_position != '' ) {
			$class[] = $this->shortcode . '_horizontal_position' . '_' . $horizontal_position;
		}
		if ( $vertical_position != '' ) {
			$class[] = $this->shortcode . '_vertical_position' . '_' . $vertical_position;
		}
		if ( $animation_delay != '' ) {
			$class[] = $this->shortcode . '_animation_delay' . '_' . $animation_delay;
		}
		if ( $animation_duration != '' ) {
			$class[] = $this->shortcode . '_animation_duration' . '_' . $animation_duration;
		}
		if ( $animation_style != '' ) {
			$class[] = $this->shortcode . '_animation_style' . '_' . $animation_style;
		}		
		
		if ( $el_class != '' ) {
			$class_attr = $class_attr . ' ' . $el_class;
		}
	
		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}	
		
		$style_attr_span = "";
		if ( $inline_css_style != '' ) {
				$style_attr_span .=  esc_attr( $inline_css_style );
		}
		if ( $background_color != '' ) {
			$background_color = bt_bb_hex2rgb( $background_color );
			$opacity = 1;
			$style_attr_span .= 'background-color: rgba(' . $background_color[0] . ', ' . $background_color[1] . ', ' . $background_color[2] . ', ' . $opacity . ');';
		}
		$background_data_attr = "";
		if ( $background_image != '' ) {
			$background_image = wp_get_attachment_image_src( $background_image, 'full' );
			if ( isset($background_image[0]) ){
				$background_image_url = $background_image[0];
				if ( $lazy_load == 'yes' ) {
					$blank_image_src = BT_BB_Root::$path . 'img/blank.gif';
					$style_attr_span .= 'background-image:url(\'' . $background_image_url . '\');';
					$background_data_attr .= ' data-background_image_src=\'' . $background_image_url . '\'';
					$class[] = 'btLazyLoadBackground';
				} else {
					$style_attr_span .= 'background-image:url(\'' . $background_image_url . '\');';				
				}
			}
		}
		if ( $style_attr_span != '' ) {
				$style_attr_span = ' ' . 'style="' . esc_attr( $style_attr_span ) . '"';
		}
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );		
		$class_attr = implode( ' ', $class );
		
		$output = '';
		
		$output .=  '<div class="' . esc_attr( $this->shortcode . '_html') . '" data-speed="' . esc_attr( $animation_speed ) . '"><span ' . $style_attr_span . '></span></div>';
		
		$output = '<div' . $id_attr . ' class="' . esc_attr( implode( ' ', $class ) ) . '"' . $style_attr . $background_data_attr . ' data-speed="' . esc_attr( $animation_speed ) . '">' . ( $output ) . '</div>';
		
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;
		
	}
	function map_shortcode() {

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Floating element', 'amwerk' ), 'description' => esc_html__( 'Absolute positioned CSS styled floating element.', 'amwerk' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'background_image', 'type' => 'attach_image', 'preview' => true, 'heading' => esc_html__( 'Background image', 'amwerk' ) 
				),
				array( 'param_name' => 'background_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Background color', 'amwerk' ) ),
				array( 'param_name' => 'inline_css_style', 'type' => 'textfield', 'heading' => esc_html__( 'Inline css style', 'amwerk' ), 'preview' => true ),
				
				array( 'param_name' => 'vertical_position', 'preview' => true, 'default' => '', 'type' => 'dropdown', 'heading' => esc_html__( 'Vertical position', 'amwerk' ), 
					'value' => array(
						esc_html__( 'Default', 'amwerk' ) 				=> 'default',
						esc_html__( 'Top (absolute)', 'amwerk' ) 		=> 'top',
						esc_html__( 'Middle (absolute)', 'amwerk' ) 	=> 'middle',
						esc_html__( 'Bottom (absolute)', 'amwerk' ) 	=> 'bottom'
					)
				),
				array( 'param_name' => 'horizontal_position', 'preview' => true, 'default' => '', 'type' => 'dropdown', 'heading' => esc_html__( 'Horizontal position', 'amwerk' ), 
					'value' => array(
						esc_html__( 'Default', 'amwerk' ) 				=> 'default',
						esc_html__( 'Left (absolute)', 'amwerk' ) 		=> 'left',
						esc_html__( 'Center (absolute)', 'amwerk' ) 	=> 'center',
						esc_html__( 'Right (absolute)', 'amwerk' ) 	=> 'right'
					)
				),
				array( 'param_name' => 'lazy_load', 'type' => 'dropdown', 'default' => 'no', 'heading' => esc_html__( 'Lazy load this image', 'amwerk' ),
					'value' => array(
						esc_html__( 'No', 'amwerk' ) 	=> 'no',
						esc_html__( 'Yes', 'amwerk' ) 	=> 'yes'
					)
				),
				array( 'param_name' => 'animation_style', 'preview' => true, 'default' => 'ease_out', 'type' => 'dropdown', 'group' => esc_html__( 'Animation', 'amwerk' ), 'heading' => esc_html__( 'Animation style (check https://easings.net/en)', 'amwerk' ), 
					'value' => array(
						esc_html__( 'Ease out (default)', 'amwerk' ) 		=> 'ease_out',
						esc_html__( 'Ease out sine', 'amwerk' ) 			=> 'ease_out_sine',
						esc_html__( 'Ease in', 'amwerk' ) 					=> 'ease_in',
						esc_html__( 'Ease in sine', 'amwerk' ) 			=> 'ease_in_sine',
						esc_html__( 'Ease in out', 'amwerk' ) 				=> 'ease_in_out',
						esc_html__( 'Ease in out sine', 'amwerk' ) 		=> 'ease_in_out_sine',
						esc_html__( 'Ease in out bounce', 'amwerk' ) 		=> 'ease_in_out_back'
					)
				),
				array( 'param_name' => 'animation_delay', 'default' => '', 'type' => 'dropdown', 'group' => esc_html__( 'Animation', 'amwerk' ), 'heading' => esc_html__( 'Animation delay', 'amwerk' ), 
					'value' => array(
						esc_html__( 'Default', 'amwerk' ) 				=> 'default',
						esc_html__( '0ms', 'amwerk' ) 					=> '0',
						esc_html__( '100ms', 'amwerk' ) 				=> '100',
						esc_html__( '200ms', 'amwerk' ) 				=> '200',
						esc_html__( '300ms', 'amwerk' ) 				=> '300',
						esc_html__( '400ms', 'amwerk' ) 				=> '400',
						esc_html__( '500ms', 'amwerk' ) 				=> '500',
						esc_html__( '600ms', 'amwerk' ) 				=> '600',
						esc_html__( '700ms', 'amwerk' ) 				=> '700',
						esc_html__( '800ms', 'amwerk' ) 				=> '800',
						esc_html__( '900ms', 'amwerk' ) 				=> '900',
						esc_html__( '1000ms', 'amwerk' ) 				=> '1000'
					)
				),
				array( 'param_name' => 'animation_duration', 'preview' => true, 'default' => '', 'type' => 'dropdown', 'group' => esc_html__( 'Animation', 'amwerk' ), 'heading' => esc_html__( 'Animation duration', 'amwerk' ), 
					'value' => array(
						esc_html__( 'Default', 'amwerk' ) 				=> 'default',
						esc_html__( '0ms', 'amwerk' ) 					=> '0',
						esc_html__( '100ms', 'amwerk' ) 				=> '100',
						esc_html__( '200ms', 'amwerk' ) 				=> '200',
						esc_html__( '300ms', 'amwerk' ) 				=> '300',
						esc_html__( '400ms', 'amwerk' ) 				=> '400',
						esc_html__( '500ms', 'amwerk' ) 				=> '500',
						esc_html__( '600ms', 'amwerk' ) 				=> '600',
						esc_html__( '700ms', 'amwerk' ) 				=> '700',
						esc_html__( '800ms', 'amwerk' ) 				=> '800',
						esc_html__( '900ms', 'amwerk' ) 				=> '900',
						esc_html__( '1000ms', 'amwerk' ) 				=> '1000',
						esc_html__( '1100ms', 'amwerk' ) 				=> '1100',
						esc_html__( '1200ms', 'amwerk' ) 				=> '1200',
						esc_html__( '1300ms', 'amwerk' ) 				=> '1300',
						esc_html__( '1400ms', 'amwerk' ) 				=> '1400',
						esc_html__( '1500ms', 'amwerk' ) 				=> '1500',
						esc_html__( '2000ms', 'amwerk' ) 				=> '2000',
						esc_html__( '2500ms', 'amwerk' ) 				=> '2500',
						esc_html__( '3000ms', 'amwerk' ) 				=> '3000',
						esc_html__( '3500ms', 'amwerk' ) 				=> '3500',
						esc_html__( '4000ms', 'amwerk' ) 				=> '4000',
						esc_html__( '5000ms', 'amwerk' ) 				=> '5000',
						esc_html__( '6000ms', 'amwerk' ) 				=> '6000'
					)
				),
				array( 'param_name' => 'animation_speed', 'preview' => true, 'default' => '1.0', 'type' => 'dropdown', 'group' => esc_html__( 'Animation', 'amwerk' ), 'heading' => esc_html__( 'Animation s', 'amwerk' ), 
					'value' => array(
						esc_html__( '0 (none)', 'amwerk' ) 				=> '0',
						esc_html__( '0.4 (very short)', 'amwerk' ) 		=> '0.4',
						esc_html__( '0.6', 'amwerk' ) 						=> '0.6',
						esc_html__( '0.8', 'amwerk' ) 						=> '0.8',
						esc_html__( '1.0', 'amwerk' ) 						=> '1.0',
						esc_html__( '1.2 (default)', 'amwerk' ) 			=> '1.2',
						esc_html__( '1.4', 'amwerk' ) 						=> '1.4',
						esc_html__( '1.6 (long)', 'amwerk' ) 				=> '1.6',
						esc_html__( '1.8', 'amwerk' ) 						=> '1.8',
						esc_html__( '2.0 (very long)', 'amwerk' ) 			=> '2.0',
						esc_html__( '2.5 (very very long)', 'amwerk' ) 	=> '2.5'
					)
				)
			)
		) );
	}
}
