<?php
class bt_bb_group extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {		
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'height'			=> '',
			'size'				=> '',
			'number'			=> '',
			'color_scheme'		=> ''
		) ), $atts, $this->shortcode ) );
		
		$regex_pattern	= '/image_size="[a-zA-Z0-9_]*"/';
		$replacement	= 'image_size="' . esc_attr( $size ) . '"';
		$content		= preg_replace($regex_pattern, $replacement, $content);

		wp_enqueue_script( 
			'bt_bb_group',
			get_template_directory_uri() . '/bold-page-builder/content_elements/bt_bb_group/bt_bb_group.js',
			array( 'jquery' ),
			'',
			true
		);
		
		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}
		
		$class = array( $this->shortcode );

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}
		
		if ( $number != '' ) {
			$class[] = $this->shortcode . '_cols' . '_' . $number;
		}
		
		if ( $color_scheme != '' ) {
			$class[] = $this->shortcode . '_color_scheme_' . bt_bb_get_color_scheme_id( $color_scheme );
		}
		
		if ( $height != '' ){
			$el_style .= ' ' . 'min-height:' . $height . ';';
		}

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}
		
		$data_attr = '';
		$size = 'full';
		if ( $size != '' ) {
			$data_attr = ' ' . 'data-size=' . $size;
		}
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		$class_attr = implode( ' ', $class );
		
		$output = '';
		
		$content = do_shortcode( $content );

		$output .= '<div' . $id_attr . ' class="' . implode( ' ', $class ) . '"' . $style_attr . $data_attr . '>' . $content . '</div>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );
		
		
		
		return $output;		
	}
	
	

	
	function map_shortcode() {
		
		require_once( WP_PLUGIN_DIR   . '/bold-page-builder/content_elements_misc/misc.php' );
		$color_scheme_arr = bt_bb_get_color_scheme_param_array();
		
		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Columns Image Feature', 'amwerk' ), 'description' => esc_html__( 'Show images with links as a feature', 'amwerk' ),  
			'container' => 'vertical', 'accept' => array( 'bt_bb_group_item' => true ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'height', 'type' => 'textfield', 'heading' => esc_html__( 'Height (e.g. 50px)', 'amwerk' ), 'description' => 'Type in the peferred height of the whole box, in PX, EM or REM.', 'preview' => true),
				array( 'param_name' => 'size', 'type' => 'dropdown', 'heading' => esc_html__( 'Image Size', 'amwerk' ), 'preview' => true,
					'value' => bt_bb_get_image_sizes()
				),
				array( 'param_name' => 'number', 'type' => 'dropdown', 'value' => '3', 'heading' => esc_html__( 'Number', 'amwerk' ), 'description' => 'Make sure there are the same number of column images as in the number you define here.', 'preview' => true,
					'value' => array(
						esc_html__( '1', 'amwerk' ) => '1',
						esc_html__( '2', 'amwerk' ) => '2',
						esc_html__( '3', 'amwerk' ) => '3',
						esc_html__( '4', 'amwerk' ) => '4',
						esc_html__( '5', 'amwerk' ) => '5',
						esc_html__( '6', 'amwerk' ) => '6'
					)
				),
				array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Color scheme', 'amwerk' ), 'value' => $color_scheme_arr, 'preview' => true ),
				
			)
		) );
	}	
}