<?php
class bt_bb_group_item extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'title'				=> '',
			'text'				=> '',
			'image'				=> '',
			'image_size'		=> '',
			'url'				=> '',
			'target'			=> '',
			'background_color' 	=> '',
			'opacity'	       	=> '' 
		) ), $atts, $this->shortcode ) );
		
		$image_size = isset( $image_size ) && $image_size != '' ? $image_size : 'full';
		
		$class = array( $this->shortcode );
		
		if ( $el_class != '' ) {
			$class[] = $el_class;
		}
		
		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}
		
		$el_style_image = '';
		if ( $background_color != '' ) {
			$background_color = bt_bb_hex2rgb( $background_color );
			if ( $opacity == '' ) {
				$opacity = 1;
			}
			$el_style_image = ' ' . 'class="bt_bb_group_item_background_color" style="background-color: rgba(' . $background_color[0] . ', ' . $background_color[1] . ', ' . $background_color[2] . ', ' . $opacity . ');"';
		}
		
		$style_attr = '';
                                
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}
		
		$alt = $title;			
		if ( $image != '' && is_numeric( $image ) ) {
			$post_image = get_post( $image );
			if ( $post_image == '' ) return;
			
			if ( $alt == '' ) {
				$alt = get_post_meta($post_image->ID, '_wp_attachment_image_alt', true);
			}
			if ( $alt == '' ) {
				$alt = $post_image->post_excerpt;
			}
			if ( $title == '' ) {
				$title = $post_image->post_title;
			}
			
			$image = wp_get_attachment_image_src( $image, $image_size );
			$image = isset($image[0]) ? $image[0] : '';
			if ( $alt == '' ) {
				$alt = $image;
			}
		}      
        
		$output_image = '';
        if ( ! empty( $image ) ) {
			$class[] = $this->shortcode . '_background_image';
			$output_image = '<span class="' . esc_attr( $this->shortcode ) . '_background_image" style="background-image:url(\'' . esc_url_raw( $image ) . '\');"><img src = "' . get_template_directory_uri() . '/gfx/empty.png" alt="' . $title . '"></span>';
		}else{
			$output_image = '<span><img src = "' . get_template_directory_uri() . '/gfx/empty.png" alt="' . $title . '"></span>';			
		}
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		
		$link = bt_bb_get_url( $url );    
		
		$output_image_item = '';
		if ( $output_image != '' ) {
			if ( ! empty( $link ) ) {
				$output_image_item .= '<div class="' . esc_attr( $this->shortcode ) . '_content_image"><a href="' . esc_url( $link ) . '"  target="' . esc_attr( $target ) . '"><span' . $el_style_image . '></span>'. $output_image .'</a></div>';
			}else{
				$output_image_item .= '<div class="' . esc_attr( $this->shortcode ) . '_content_image">' . $output_image . '</div>';
			}
		}
		
		$output = '';
		
		$output .= '<div class="' . esc_attr( $this->shortcode ) . '_content">';
			$output .= $output_image_item;
			$output .= '<div class="' . esc_attr( $this->shortcode ) . '_content_hover"><div class="' . esc_attr( $this->shortcode ) . '_arrow"></div><div class="' . esc_attr( $this->shortcode ) . '_content_hover_wrapper">';
				$output .= '<div class="' . esc_attr( $this->shortcode ) . '_content_title"><h3>' . $title . '</h3></div>';
				$output .= '<div class="' . esc_attr( $this->shortcode ) . '_content_text">' . nl2br( $text ) . '</div>';
			$output .= '</div></div>';	
			$output .= '<div class="' . esc_attr( $this->shortcode ) . '_content_no_hover">';
				$output .= '<div class="' . esc_attr( $this->shortcode ) . '_content_title"><h3>' . $title . '</h3></div>';
			$output .= '</div>';
		$output .= '</div>';
		
		$output = '<div' . $id_attr . ' class="' . esc_attr( implode( ' ', $class ) ) . '"' . $style_attr . ' data-size="">' . $output . '</div>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );
		
		return $output;
	}
	
	function map_shortcode() {
		
		require_once( WP_PLUGIN_DIR   . '/bold-page-builder/content_elements_misc/misc.php' );
		$color_scheme_arr = bt_bb_get_color_scheme_param_array();
		
		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Single Feature', 'amwerk' ), 'description' => esc_html__( 'Single group element', 'amwerk' ), 
			'container' => 'vertical', 'as_child' => array( 'only' => 'bt_bb_group' ),  'accept' => array( 'bt_bb_section' => false, 'bt_bb_row' => false, 'bt_bb_column' => false, 'bt_bb_column_inner' => false, 
			'bt_bb_tabs' => false,'bt_bb_tab_item' => false, 'bt_bb_accordion' => false, 'bt_bb_accordion_item' => false, 'bt_bb_cost_calculator_item' => false, 'bt_cc_group' => false, 
			'bt_cc_multiply' => false, 'bt_cc_item' => false, 'bt_bb_content_slider_item' => false, 'bt_bb_google_maps_location' => false, '_content' => false ),
			'accept_all' => false, 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'title', 'type' => 'textfield', 'heading' => esc_html__( 'Title', 'amwerk' ), 'preview' => true ),
				array( 'param_name' => 'text', 'type' => 'textarea', 'heading' => esc_html__( 'Text', 'amwerk' ) ),
				array( 'param_name' => 'image', 'type' => 'attach_image', 'heading' => esc_html__( 'Image', 'amwerk' ), 'preview' => true ),
				array( 'param_name' => 'url', 'type' => 'textfield', 'heading' => esc_html__( 'URL', 'amwerk' ), 'group' => esc_html__( 'URL', 'amwerk' ) ),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'heading' => esc_html__( 'Target', 'amwerk' ), 'group' => esc_html__( 'URL', 'amwerk' ),
					'value' => array(
						esc_html__( 'Self (open in same tab)', 'amwerk' ) => '_self',
						esc_html__( 'Blank (open in new tab)', 'amwerk' ) => '_blank',
					)
				),
				array( 'param_name' => 'background_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Background color', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ) ),
				array( 'param_name' => 'opacity', 'type' => 'textfield', 'heading' => esc_html__( 'Background color opacity (e.g. 0.4)', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ) )
			)
		) );
	}
	
}