<?php

class bt_bb_headline extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'headline'      		=> '',
			'html_tag'      		=> '',
			'font'          		=> '',
			'font_subset'   		=> '',
			'size'     				=> '',
			'font_size'     		=> '',
			'font_weight'   		=> '',
			'color_scheme'  		=> '',
			'color'         		=> '',
			'supertitle_position'   => '',
			'dash'          		=> '',
			'align'         		=> '',
			'url'           		=> '',
			'target'        		=> '',
			'superheadline' 		=> '',
			'subheadline'   		=> '',
			'outline_text'			=> '',
			'outline_size'			=> '',
			'outline_align' 		=> ''
		) ), $atts, $this->shortcode ) );

		$superheadline = html_entity_decode( $superheadline, ENT_QUOTES, 'UTF-8' );
		$subheadline = html_entity_decode( $subheadline, ENT_QUOTES, 'UTF-8' );
		$headline = html_entity_decode( $headline, ENT_QUOTES, 'UTF-8' );

		if ( $font != '' && $font != 'inherit' ) {
			require_once( WP_PLUGIN_DIR   . '/bold-page-builder/content_elements_misc/misc.php' );
			bt_bb_enqueue_google_font( $font, $font_subset );
		}

		$class = array( $this->shortcode );
		
		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}
		
		$html_tag_style = "";
		$html_tag_style_arr = array();
		if ( $font != '' && $font != 'inherit' ) {
			$el_style = $el_style . ';' . 'font-family:\'' . urldecode( $font ) . '\'';
			$html_tag_style_arr[] = 'font-family:\'' . urldecode( $font ) . '\'';
		}
		if ( $font_size != '' ) {
			$html_tag_style_arr[] = 'font-size:' . $font_size  ;
		}
		if ( count( $html_tag_style_arr ) > 0 ) {
			$html_tag_style = ' style="' . implode( '; ', $html_tag_style_arr ) . '"';
		}
		
		if ( $font_weight != '' ) {
			$class[] = $this->prefix . 'font_weight_' . $font_weight ;
		}
		
		if ( $color_scheme != '' ) {
			$class[] = $this->prefix . 'color_scheme_' . bt_bb_get_color_scheme_id( $color_scheme );
		}

		if ( $color != '' ) {
			$el_style = $el_style . ';' . 'color:' . $color . ';border-color:' . $color . ';';
		}

		if ( $dash != '' ) {
			$class[] = $this->prefix . 'dash' . '_' . $dash;
		}
		
		if ( $size != '' ) {
			$class[] = $this->prefix . 'size' . '_' . $size;
		}
		
		if ( $target == '' ) {
			$target = '_self';
		}

		$superheadline_inside = '';
		$superheadline_outside = '';
		
		if ( $superheadline != '' ) {
			$class[] = $this->prefix . 'superheadline';
			if ( $supertitle_position == 'outside' ) { 
				$superheadline_outside = '<span class="' . esc_attr( $this->shortcode ) . '_superheadline"><span>' . $superheadline . '</span></span>';
			} else {
				$superheadline_inside = '<span class="' . esc_attr( $this->shortcode ) . '_superheadline"><span>' . $superheadline . '</span></span>';
			}
			
		}
		
		if ( $subheadline != '' ) {
			$class[] = $this->prefix . 'subheadline';
			$subheadline = '<div class="' . esc_attr( $this->shortcode ) . '_subheadline">' . $subheadline . '</div>';
			$subheadline = nl2br( $subheadline );
		}
		

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}

		if ( $align != '' ) {
			$class[] = $this->prefix . 'align' . '_' . $align;
		}
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		
		// outline text		
		if ( $outline_text != '' ) {
			$class_outline = array( $this->prefix . 'outline_text' );
			if ( $outline_align != '' ) {
				$class_outline[] = $this->prefix . 'outline_text_align' . '_' . $outline_align;
			}
			if ( $outline_size != '' ) {
				$class_outline[] = $this->prefix . 'outline_text_size' . '_' . $outline_size;
			}		
			$outline_text = '<span class="' . implode( ' ', $class_outline ) . '"><span>' . $outline_text . '</span></span>';			
			$outline_text = nl2br( $outline_text );
		}
		
		if ( $headline != '' ) {
			if ( $url != '' ) {
				$url_title = strip_tags( str_replace( array("\n", "\r"), ' ', $headline ) );
				$link = bt_bb_get_url( $url );
				// IMPORTANT: esc_attr must be used instead of esc_url(_raw)
				$headline = '<a href="' . esc_attr( $link ) . '" target="' . esc_attr( $target ) . '" title="' . esc_attr( $url_title )  . '">' . $headline . '</a>';
			}		
			$headline = '<span class="' . esc_attr( $this->shortcode ) . '_content"><span>' . $headline . $outline_text . '</span></span>';			
		}
		
		$headline = nl2br( $headline );		
		
		$output = '<header' . $id_attr . ' class="' . implode( ' ', $class ) . '"' . $style_attr . '>';
		if ( $superheadline_outside != '' ) $output .= '<div class="' . esc_attr( $this->shortcode ) . '_superheadline_outside' . '">' . $superheadline_outside . '</div>';
		if ( $headline != '' || $superheadline_inside != '' ) $output .= '<' . $html_tag . $html_tag_style . '>' . $superheadline_inside . $headline . '</' . $html_tag . '>';
		$output .= $subheadline . '</header>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}

	function map_shortcode() {

		require( WP_PLUGIN_DIR   . '/bold-page-builder/content_elements_misc/fonts.php' );
		$color_scheme_arr = bt_bb_get_color_scheme_param_array();	

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Headline', 'amwerk' ), 'description' => esc_html__( 'Headline with custom Google fonts', 'amwerk' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode, 'highlight' => true,
			'params' => array(
				array( 'param_name' => 'superheadline', 'type' => 'textfield', 'heading' => esc_html__( 'Superheadline', 'amwerk' ) ),
				array( 'param_name' => 'headline', 'type' => 'textarea', 'heading' => esc_html__( 'Headline', 'amwerk' ), 'preview' => true, 'preview_strong' => true ),
				array( 'param_name' => 'subheadline', 'type' => 'textarea', 'heading' => esc_html__( 'Subheadline', 'amwerk' ) ),
				array( 'param_name' => 'html_tag', 'type' => 'dropdown', 'heading' => esc_html__( 'HTML tag', 'amwerk' ), 'preview' => true,
					'value' => array(
						esc_html__( 'h1', 'amwerk' ) => 'h1',
						esc_html__( 'h2', 'amwerk' ) => 'h2',
						esc_html__( 'h3', 'amwerk' ) => 'h3',
						esc_html__( 'h4', 'amwerk' ) => 'h4',
						esc_html__( 'h5', 'amwerk' ) => 'h5',
						esc_html__( 'h6', 'amwerk' ) => 'h6'
				) ),
				array( 'param_name' => 'size', 'type' => 'dropdown', 'heading' => esc_html__( 'Size', 'amwerk' ), 'description' => 'Predefined heading sizes, independent of html tag',
					'value' => array(
						esc_html__( 'Inherit', 'amwerk' ) => 'inherit',
						esc_html__( 'Extra Small', 'amwerk' ) => 'extrasmall',
						esc_html__( 'Small', 'amwerk' ) => 'small',
						esc_html__( 'Medium', 'amwerk' ) => 'medium',
						esc_html__( 'Normal', 'amwerk' ) => 'normal',
						esc_html__( 'Large', 'amwerk' ) => 'large',
						esc_html__( 'Extra large', 'amwerk' ) => 'extralarge',
						esc_html__( 'Huge', 'amwerk' ) => 'huge',
						esc_html__( 'Extra huge', 'amwerk' ) => 'extrahuge'
					)
				),				
				array( 'param_name' => 'align', 'type' => 'dropdown', 'heading' => esc_html__( 'Alignment', 'amwerk' ),
					'value' => array(
						esc_html__( 'Inherit', 'amwerk' ) => 'inherit',
						esc_html__( 'Center', 'amwerk' ) => 'center',
						esc_html__( 'Left', 'amwerk' ) => 'left',
						esc_html__( 'Right', 'amwerk' ) => 'right'
					)
				),
				array( 'param_name' => 'dash', 'type' => 'dropdown', 'heading' => esc_html__( 'Dash', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ),
					'value' => array(
						esc_html__( 'None', 'amwerk' ) => 'none',
						esc_html__( 'Top', 'amwerk' ) => 'top',
						esc_html__( 'Bottom', 'amwerk' ) => 'bottom',
						esc_html__( 'Top and bottom', 'amwerk' ) => 'top_bottom'
					)
				),
				array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Color scheme', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ), 'value' => $color_scheme_arr, 'preview' => true ),
				array( 'param_name' => 'color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Color', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ), 'preview' => true ),
				array( 'param_name' => 'supertitle_position', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'amwerk' ) => 'outside' ), 'heading' => esc_html__( 'Put supertitle outside H tag', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ), 'preview' => true ),
				array( 'param_name' => 'font', 'type' => 'dropdown', 'heading' => esc_html__( 'Font', 'amwerk' ), 'group' => esc_html__( 'Font', 'amwerk' ), 'preview' => true,
					'value' => array( esc_html__( 'Inherit', 'amwerk' ) => 'inherit' ) + $font_arr
				),
				array( 'param_name' => 'font_subset', 'type' => 'textfield', 'heading' => esc_html__( 'Google Font subset', 'amwerk' ), 'group' => esc_html__( 'Font', 'amwerk' ), 'value' => 'latin,latin-ext', 'description' => 'E.g. latin,latin-ext,cyrillic,cyrillic-ext' ),
				array( 'param_name' => 'font_size', 'type' => 'textfield', 'heading' => esc_html__( 'Custom font size', 'amwerk' ), 'group' => esc_html__( 'Font', 'amwerk' ), 'description' => 'E.g. 20px or 1.5rem' ),
				array( 'param_name' => 'font_weight', 'type' => 'dropdown', 'heading' => esc_html__( 'Font weight', 'amwerk' ), 'group' => esc_html__( 'Font', 'amwerk' ),
					'value' => array(
						esc_html__( 'Default', 'amwerk' ) => '',
						esc_html__( 'Normal', 'amwerk' ) => 'normal',
						esc_html__( 'Bold', 'amwerk' ) => 'bold',
						esc_html__( 'Bolder', 'amwerk' ) => 'bolder',
						esc_html__( 'Lighter', 'amwerk' ) => 'lighter',
						esc_html__( 'Light', 'amwerk' ) => 'light',
						esc_html__( 'Thin', 'amwerk' ) => 'thin',
						esc_html__( 'Font weight 100', 'amwerk' ) => '100',
						esc_html__( 'Font weight 200', 'amwerk' ) => '200',
						esc_html__( 'Font weight 300', 'amwerk' ) => '300',
						esc_html__( 'Font weight 400', 'amwerk' ) => '400',
						esc_html__( 'Font weight 500', 'amwerk' ) => '500',
						esc_html__( 'Font weight 600', 'amwerk' ) => '600',
						esc_html__( 'Font weight 700', 'amwerk' ) => '700',
						esc_html__( 'Font weight 800', 'amwerk' ) => '800',
						esc_html__( 'Font weight 900', 'amwerk' ) => '900'
					)
				),
				array( 'param_name' => 'url', 'type' => 'textfield', 'heading' => esc_html__( 'URL', 'amwerk' ), 'group' => esc_html__( 'URL', 'amwerk' ) ),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'heading' => esc_html__( 'Target', 'amwerk' ), 'group' => esc_html__( 'URL', 'amwerk' ),
					'value' => array(
						esc_html__( 'Self (open in same tab)', 'amwerk' ) => '_self',
						esc_html__( 'Blank (open in new tab)', 'amwerk' ) => '_blank'
					)
				),
				array( 'param_name' => 'outline_text', 'type' => 'textfield', 'heading' => esc_html__( 'Outline Text', 'amwerk' ), 'group' => esc_html__( 'Outline Text', 'amwerk' ) ),
				array( 'param_name' => 'outline_size', 'type' => 'dropdown', 'heading' => esc_html__( 'Outline Size', 'amwerk' ), 'group' => esc_html__( 'Outline Text', 'amwerk' ), 'description' => 'Select the size of the headline outline text, compared to the size of the headline.',
					'value' => array(
						esc_html__( 'Default', 'amwerk' ) => 'inherit',
						esc_html__( '150%', 'amwerk' ) => '150',
						esc_html__( '200%', 'amwerk' ) => '200',
						esc_html__( '300%', 'amwerk' ) => '300',
						esc_html__( '400%', 'amwerk' ) => '400',
						esc_html__( '500%', 'amwerk' ) => '500'
					)
				),			
				array( 'param_name' => 'outline_align', 'type' => 'dropdown', 'heading' => esc_html__( 'Alignment', 'amwerk' ), 'description' => 'Alignes outline text to the center, left or right edge of the headline content.', 'group' => esc_html__( 'Outline Text', 'amwerk' ),
					'value' => array(
						esc_html__( 'Inherit', 'amwerk' ) => 'inherit',
						esc_html__( 'Center', 'amwerk' ) => 'center',
						esc_html__( 'Left', 'amwerk' ) => 'left',
						esc_html__( 'Right', 'amwerk' ) => 'right'
					)
				),
			)
		) );
	}
}