<?php


class bt_bb_headline_with_icon extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'headline'      		=> '',
			'html_tag'      		=> '',
			'font'          		=> '',
			'font_subset'   		=> '',
			'size'     				=> '',
			'font_size'     		=> '',
			'font_weight'   		=> '',
			'color_scheme'  		=> '',
			'color'         		=> '',
			'supertitle_position'   => '',
			'align'         		=> '',
			'url'           		=> '',
			'target'        		=> '',
			'superheadline' 		=> '',
			'subheadline'   		=> '',
			'icon'					=> '',
			'icon_position'			=> '',
			'icon_color_scheme'		=> '',
			'content_background_color'		=> '',
			'content_background_opacity'	=> ''
		) ), $atts, $this->shortcode ) );
		
		$superheadline = html_entity_decode( $superheadline, ENT_QUOTES, 'UTF-8' );
		$subheadline = html_entity_decode( $subheadline, ENT_QUOTES, 'UTF-8' );
		$headline = html_entity_decode( $headline, ENT_QUOTES, 'UTF-8' );
		
		if ( $font != '' && $font != 'inherit' ) {
			require_once( WP_PLUGIN_DIR   . '/bold-page-builder/content_elements_misc/misc.php' );
			bt_bb_enqueue_google_font( $font, $font_subset );
		}

		$class = array( $this->shortcode );
		
		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}
		
		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}
		
		$html_tag_style = "";
		$html_tag_style_arr = array();
		if ( $font != '' && $font != 'inherit' ) {
			$el_style = $el_style . ';' . 'font-family:\'' . urldecode( $font ) . '\'';
			$html_tag_style_arr[] = 'font-family:\'' . urldecode( $font ) . '\'';
		}
		if ( $font_size != '' ) {
			$html_tag_style_arr[] = 'font-size:' . $font_size  ;
		}
		if ( count( $html_tag_style_arr ) > 0 ) {
			$html_tag_style = ' style="' . implode( '; ', $html_tag_style_arr ) . '"';
		}
		
		if ( $font_weight != '' ) {
			$class[] = $this->prefix . 'font_weight_' . $font_weight ;
		}
		
		if ( $color_scheme != '' ) {
			$class[] = $this->prefix . 'color_scheme_' . bt_bb_get_color_scheme_id( $color_scheme );
		}

		if ( $color != '' ) {
			$el_style = $el_style . ';' . 'color:' . $color . ';border-color:' . $color . ';';
		}

		
		if ( $size != '' ) {
			$class[] = $this->prefix . 'size' . '_' . $size;
		}
		
		if ( $target == '' ) {
			$target = '_self';
		}

		$superheadline_inside = '';
		$superheadline_outside = '';
		
		if ( $superheadline != '' ) {
			$class[] = $this->prefix . 'superheadline';
			if ( $supertitle_position == 'outside' ) { 
				$superheadline_outside = '<span class="' . esc_attr( $this->shortcode ) . '_superheadline">' . $superheadline . '</span>';
			} else {
				$superheadline_inside = '<span class="' . esc_attr( $this->shortcode ) . '_superheadline">' . $superheadline . '</span>';
			}
		}
		
		if ( $subheadline != '' ) {
			$class[] = $this->prefix . 'subheadline';
			$subheadline = '<div class="' . esc_attr( $this->shortcode ) . '_subheadline">' . $subheadline . '</div>';
			$subheadline = nl2br( $subheadline );
		}		

		if ( $align != '' ) {
			$class[] = $this->prefix . 'align' . '_' . $align;
		}
		
		if ( $icon_position != '' ) {
			$class[] = $this->prefix . 'icon_position' . '_' . $icon_position;
		}
		
		if ( $icon_color_scheme != '' ) {
			$class[] = $this->prefix . 'icon_color_scheme_' . bt_bb_get_color_scheme_id( $icon_color_scheme );
		}
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		
		$output_icon = '';		
		if ( $icon != '' && $icon != 'no_icon' ) {
			$output_icon = bt_bb_headline_with_icon::get_icon_html( $icon, '' );
		}
		
		if ( $headline != '' ) {
			if ( $url != '' ) {
				$url_title = strip_tags( str_replace( array("\n", "\r"), ' ', $headline ) );
				$link = bt_bb_get_url( $url );
				// IMPORTANT: esc_attr must be used instead of esc_url(_raw)
				$headline = '<a href="' . esc_attr( $link ) . '" target="' . esc_attr( $target ) . '" title="' . esc_attr( $url_title )  . '">' . $headline . '</a>';
			}		
			$headline = '<span class="' . esc_attr( $this->shortcode ) . '_content"><span>' . $headline . '</span></span>';			
		}
		
		$headline = nl2br( $headline );
		
		$content_background_style_attr = '';
		if ( $content_background_color != '' ) {
			$content_background_color	= bt_bb_image::hex2rgb( $content_background_color );
			if ( $content_background_opacity == '' ) {
				$content_background_opacity = 1;
			}
			$content_background_style_attr = ' style="--bgcolor: rgba(' . $content_background_color[0] . ', ' . $content_background_color[1] . ', ' . $content_background_color[2] . ', ' . $content_background_opacity . ');background-color: rgba(' . $content_background_color[0] . ', ' . $content_background_color[1] . ', ' . $content_background_color[2] . ', ' . $content_background_opacity . ');"';
		}

		$output = '<header' . $id_attr . ' class="' . implode( ' ', $class ) . '"' . $style_attr . '>';
			if ( $output_icon != '' ) $output .= $output_icon;
			$output .='<div class="' . esc_attr( $this->shortcode ) . '_content_holder' . '"' . $content_background_style_attr . '>';
				if ( $superheadline_outside != '' ) $output .= '<div class="' . esc_attr( $this->shortcode ) . '_superheadline_outside' . '">' . $superheadline_outside . '</div>';
				if ( $headline != '' || $superheadline_inside != '' ) $output .= '<' . $html_tag . $html_tag_style . '>' . $superheadline_inside . $headline . '</' . $html_tag . '>';
				$output .= $subheadline; 
			$output .='</div>';
		$output .='</header>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;
	}
	
	static function get_icon_html( $icon, $text = '' ) {
		$icon_set	= substr( $icon, 0, -5 );
		$icon		= substr( $icon, -4 );
		return '<span data-ico-' . esc_attr( $icon_set ) . '="&#x' . esc_attr( $icon ) . ';" class="bt_bb_icon_holder">' . $text . '</span>';
	}
	
	function map_shortcode() {

		require( WP_PLUGIN_DIR   . '/bold-page-builder/content_elements_misc/fonts.php' );
		
		require_once( WP_PLUGIN_DIR   . '/bold-page-builder/content_elements_misc/misc.php' );		
		$color_scheme_arr = bt_bb_get_color_scheme_param_array();
		
		if ( function_exists('boldthemes_get_icon_fonts_bb_array') ) {
			$icon_arr = boldthemes_get_icon_fonts_bb_array();
		} else {
			require_once( WP_PLUGIN_DIR   . '/bold-page-builder/content_elements_misc/fa_icons.php' );
			require_once( WP_PLUGIN_DIR   . '/bold-page-builder/content_elements_misc/s7_icons.php' );
			$icon_arr = array( 'Font Awesome' => bt_bb_fa_icons(), 'S7' => bt_bb_s7_icons() );
		}

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Headline with icon', 'amwerk' ), 'description' => esc_html__( 'Headline with custom Google fonts and Icon', 'amwerk' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode, 'highlight' => true,
			'params' => array(
				array( 'param_name' => 'superheadline', 'type' => 'textfield', 'heading' => esc_html__( 'Superheadline', 'amwerk' ) ),
				array( 'param_name' => 'headline', 'type' => 'textarea', 'heading' => esc_html__( 'Headline', 'amwerk' ), 'preview' => true, 'preview_strong' => true ),
				array( 'param_name' => 'subheadline', 'type' => 'textarea', 'heading' => esc_html__( 'Subheadline', 'amwerk' ) ),
				array( 'param_name' => 'html_tag', 'type' => 'dropdown', 'heading' => esc_html__( 'HTML tag', 'amwerk' ), 'preview' => true,
					'value' => array(
						esc_html__( 'h1', 'amwerk' ) => 'h1',
						esc_html__( 'h2', 'amwerk' ) => 'h2',
						esc_html__( 'h3', 'amwerk' ) => 'h3',
						esc_html__( 'h4', 'amwerk' ) => 'h4',
						esc_html__( 'h5', 'amwerk' ) => 'h5',
						esc_html__( 'h6', 'amwerk' ) => 'h6'
				) ),
				array( 'param_name' => 'icon', 'type' => 'iconpicker', 'heading' => esc_html__( 'Icon', 'amwerk' ), 'value' => $icon_arr, 'group' => esc_html__( 'Icon', 'amwerk' ), 'preview' => true ),
				array( 'param_name' => 'icon_position', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon Position', 'amwerk' ), 'group' => esc_html__( 'Icon', 'amwerk' ),
					'value' => array(
						esc_html__( 'Left', 'amwerk' ) => 'left',
						esc_html__( 'Right', 'amwerk' ) => 'right'
					)
				),
				array( 'param_name' => 'icon_color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon Color Scheme', 'amwerk' ), 'value' => $color_scheme_arr, 'group' => esc_html__( 'Icon', 'amwerk' ), 'preview' => true ),
				array( 'param_name' => 'size', 'type' => 'dropdown', 'heading' => esc_html__( 'Size', 'amwerk' ), 'description' => 'Predefined heading sizes, independent of html tag',
					'value' => array(
						esc_html__( 'Inherit', 'amwerk' ) => 'inherit',
						esc_html__( 'Extra Small', 'amwerk' ) => 'extrasmall',
						esc_html__( 'Small', 'amwerk' ) => 'small',
						esc_html__( 'Medium', 'amwerk' ) => 'medium',
						esc_html__( 'Normal', 'amwerk' ) => 'normal',
						esc_html__( 'Large', 'amwerk' ) => 'large',
						esc_html__( 'Extra large', 'amwerk' ) => 'extralarge',
						esc_html__( 'Huge', 'amwerk' ) => 'huge'
					)
				),				
				array( 'param_name' => 'align', 'type' => 'dropdown', 'heading' => esc_html__( 'Alignment', 'amwerk' ),
					'value' => array(
						esc_html__( 'Inherit', 'amwerk' ) => 'inherit',
						esc_html__( 'Center', 'amwerk' ) => 'center',
						esc_html__( 'Left', 'amwerk' ) => 'left',
						esc_html__( 'Right', 'amwerk' ) => 'right'
					)
				),				
				array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Color scheme', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ), 'value' => $color_scheme_arr, 'preview' => true ),
				array( 'param_name' => 'color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Color', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ), 'preview' => true ),
				array( 'param_name' => 'supertitle_position', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'amwerk' ) => 'outside' ), 'heading' => esc_html__( 'Put supertitle outside H tag', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ), 'preview' => true ),
				array( 'param_name' => 'font', 'type' => 'dropdown', 'heading' => esc_html__( 'Font', 'amwerk' ), 'group' => esc_html__( 'Font', 'amwerk' ), 'preview' => true,
					'value' => array( esc_html__( 'Inherit', 'amwerk' ) => 'inherit' ) + $font_arr
				),
				array( 'param_name' => 'font_subset', 'type' => 'textfield', 'heading' => esc_html__( 'Font subset', 'amwerk' ), 'group' => esc_html__( 'Font', 'amwerk' ), 'value' => 'latin,latin-ext', 'description' => 'E.g. latin,latin-ext,cyrillic,cyrillic-ext' ),
				array( 'param_name' => 'font_size', 'type' => 'textfield', 'heading' => esc_html__( 'Custom font size', 'amwerk' ), 'group' => esc_html__( 'Font', 'amwerk' ), 'description' => 'E.g. 20px or 1.5rem' ),
				array( 'param_name' => 'font_weight', 'type' => 'dropdown', 'heading' => esc_html__( 'Font weight', 'amwerk' ), 'group' => esc_html__( 'Font', 'amwerk' ),
					'value' => array(
						esc_html__( 'Default', 'amwerk' ) => '',
						esc_html__( 'Normal', 'amwerk' ) => 'normal',
						esc_html__( 'Bold', 'amwerk' ) => 'bold',
						esc_html__( 'Bolder', 'amwerk' ) => 'bolder',
						esc_html__( 'Lighter', 'amwerk' ) => 'lighter',
						esc_html__( 'Light', 'amwerk' ) => 'light',
						esc_html__( 'Thin', 'amwerk' ) => 'thin'
					)
				),
				array( 'param_name' => 'url', 'type' => 'textfield', 'heading' => esc_html__( 'URL', 'amwerk' ), 'group' => esc_html__( 'URL', 'amwerk' ) ),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'heading' => esc_html__( 'Target', 'amwerk' ), 'group' => esc_html__( 'URL', 'amwerk' ),
					'value' => array(
						esc_html__( 'Self (open in same tab)', 'amwerk' ) => '_self',
						esc_html__( 'Blank (open in new tab)', 'amwerk' ) => '_blank'
					)
				),
				array( 'param_name' => 'content_background_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Background color', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ) ),
				array( 'param_name' => 'content_background_opacity', 'type' => 'textfield', 'heading' => esc_html__( 'Content background opacity (e.g. 0.4)', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ) ),
				
			)
		) );
	}
	
	
}
