<?php

class bt_bb_image extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'image'  							=> '',
			'size'   							=> '',
			'shape'  							=> '',
			'lazy_load'  						=> 'no',
			'image_height'  					=> '',
			'align'  							=> '',
			'caption'    						=> '',
			'url'    							=> '',
			'target' 							=> '',
			'hover_style'  						=> '',
			'content_display'  					=> '',
			'content_background_color' 			=> '',
			'content_background_opacity'	    => '',
			'content_align'						=> '',
			'remove_padding'					=> '',
			'fill_background_color'				=> ''			
		) ), $atts, $this->shortcode ) );
		
		require_once( WP_PLUGIN_DIR   . '/bold-page-builder/content_elements_misc/misc.php' );
		
		$class = array( $this->shortcode );
		
		if ( $el_class != '' ) {
			$class[] = $el_class;
		}
		
		if ( $hover_style == 'scroll' ) {
			$el_id = 'bt_bb_random_id_' . rand();
		}

		$style_attr = '';
		
		if ( $image_height != '' ) {
			$el_style .= 'height:' . $image_height . '; overflow: hidden;';
		}
		
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}	
		
		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		
		if ( $shape != '' ) {
			$class[] = $this->prefix . 'shape' . '_' . $shape;
		}
		
		if ( $align != '' ) {
			$class[] = $this->prefix . 'align' . '_' . $align;
		}
		
		if ( $hover_style != '' ) {
			$class[] = $this->prefix . 'hover_style' . '_' . $hover_style;
		}
		
		if ( $content_display != '' ) {
			$class[] = $this->prefix . 'content_display' . '_' . $content_display;
		}

		if ( $content_align != '' ) {
			$class[] = $this->prefix . 'content_align' . '_' . $content_align;
		}
		
		if ( $remove_padding != '' ) {
			$class[] = $this->prefix . 'remove_padding' . '_' . $remove_padding;
		}
		
		if ( $fill_background_color != '' ) {
			$class[] = $this->prefix . 'fill_background_color' . '_' . $fill_background_color;
		}
		
		
		

		$alt = $caption;
		$title = $caption;
		$full_image = $image;
		$image_ = $image;
			
		if ( $image != '' && is_numeric( $image ) ) {
			$post_image = get_post( $image );
			if ( $post_image == '' ) return;
			
			if ( $alt == '' ) {
				$alt = get_post_meta($post_image->ID, '_wp_attachment_image_alt', true);
			}
			if ( $alt == '' ) {
				$alt = $post_image->post_excerpt;
			}
			if ( $title == '' ) {
				$title = $post_image->post_title;
			}
			
			$image_ = wp_get_attachment_image_src( $image, $size );
			if ( $image_ ) {
				$image_ = $image_[0];
			}
			if ( $alt == '' ) {
				$alt = $image_;
			}
			
			if ( $size == 'full' ) {
				$full_image = $image_;
			} else {
				$full_image = wp_get_attachment_image_src( $image, 'full' );
				if ( $full_image ) {
					$full_image = $full_image[0];
				} else {
					$full_image = '';
				}				
			}
		}
		
		if ( $title != '' ) {
			$title = ' title="' . esc_attr( $title ) . '"';	
		}
		$content = do_shortcode( $content );
		
		if ( $content != '' ) {
			$class[] = $this->prefix . 'content_exists';
		}
		
		$output = '';
		
		if ( ! empty( $image_ ) ) {
			if ( $lazy_load == 'yes' ) {
				$output .= '<img src = "' . BT_BB_Root::$path . 'img/blank.gif" data-full_image_src="' . esc_url_raw( $full_image ) . '" data-image_src="' . esc_url_raw( $image_ ) . '"' . $title . ' alt="' . esc_attr( $alt ) . '" class="btLazyLoadImage">';
			} else {
				$output .= '<img src="' . esc_url_raw( $image_ ) . '" data-full_image_src="' . esc_url_raw( $full_image ) . '" ' . $title . ' alt="' . esc_attr( $alt ) . '">';
			}
		}
		if ( $url != '#lightbox' ) {
			$link = bt_bb_get_url( $url );	
		} else {
			$link = $url ;
			$class[] = 'bt_bb_use_lightbox';
		}
		
		if ( ! empty( $link ) ) {
			$output = '<a href="' . esc_url( $link ) . '"  target="' . esc_attr( $target ) . '"' . $title . '>' . $output . '</a>';
		} else {
			$output = '<span>' . $output . '</span>';
		}
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		
		$output = '<div' . $id_attr . ' class="' . esc_attr( implode( ' ', $class ) ) . '"' . $style_attr . '>' . $output ;
		if ( $content != '' ) {
			$content_background_style = '';
			if ( $content_background_color != '' ) {
				$content_background_color	= bt_bb_image::hex2rgb( $content_background_color );
				if ( $content_background_opacity == '' ) {
					$content_background_opacity = 1;
				}
				$content_background_style .= ' style="--bgcolor: rgba(' . $content_background_color[0] . ', ' . $content_background_color[1] . ', ' . $content_background_color[2] . ', ' . $content_background_opacity . ');background-color: rgba(' . $content_background_color[0] . ', ' . $content_background_color[1] . ', ' . $content_background_color[2] . ', ' . $content_background_opacity . ');"';
			}
			$output .= '<div class="bt_bb_image_content"' . $content_background_style . '><div class="bt_bb_image_content_flex"><div class="bt_bb_image_content_inner">' . $content . '</div></div></div>';
		}
		$output .= '</div>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );
		
		return $output;

	}

	function map_shortcode() {
		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Image', 'amwerk' ), 'description' => esc_html__( 'Single image', 'amwerk' ), 'container' => 'vertical', 'accept' => array( 'bt_bb_button' => true, 'bt_bb_icon' => true, 'bt_bb_text' => true, 'bt_bb_headline' => true, 'bt_bb_separator' => true , 'bt_bb_headline_with_icon' => true), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'image', 'type' => 'attach_image', 'heading' => esc_html__( 'Image', 'amwerk' ), 'preview' => true ),
				array( 'param_name' => 'size', 'type' => 'dropdown', 'heading' => esc_html__( 'Size', 'amwerk' ), 'preview' => true,
					'value' => bt_bb_get_image_sizes()
				),
				array( 'param_name' => 'image_height', 'type' => 'textfield', 'heading' => esc_html__( 'Image height', 'amwerk' )),
				array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Shape', 'amwerk' ),
					'value' => array(
						esc_html__('Square', 'amwerk' ) => 'square',
						esc_html__('Soft Rounded', 'amwerk' ) => 'soft-rounded',
						esc_html__('Hard Rounded', 'amwerk' ) => 'hard-rounded',
						esc_html__('Hexagon', 'amwerk' ) => 'hexagon',
						esc_html__('Hexagon Rounded', 'amwerk' ) => 'hexagon-rounded'
					)
				),
				array( 'param_name' => 'lazy_load', 'type' => 'dropdown', 'default' => 'yes', 'heading' => esc_html__( 'Lazy load this image', 'amwerk' ),
					'value' => array(
						esc_html__( 'No', 'amwerk' ) => 'no',
						esc_html__( 'Yes', 'amwerk' ) => 'yes'
					)
				),
				array( 'param_name' => 'align', 'type' => 'dropdown', 'heading' => esc_html__( 'Alignment', 'amwerk' ),
					'value' => array(
						esc_html__( 'Inherit', 'amwerk' ) => 'inherit',
						esc_html__( 'Left', 'amwerk' ) => 'left',
						esc_html__( 'Right', 'amwerk' ) => 'right'
					)
				),
				array( 'param_name' => 'caption', 'type' => 'textfield', 'heading' => esc_html__( 'Caption', 'amwerk' ) ),
				array( 'param_name' => 'url', 'type' => 'textfield', 'heading' => esc_html__( 'URL', 'amwerk' ), 'description' => esc_html__( 'Enter full or local URL (eg. https://www.bold-themes.com or /pages/about-us), post slug (eg. about-us) or #lightbox to open current image in full size', 'amwerk' ), 'group' => esc_html__( 'URL', 'amwerk' ) ),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'heading' => esc_html__( 'Target', 'amwerk' ), 'group' => esc_html__( 'URL', 'amwerk' ),
					'value' => array(
						esc_html__( 'Self (open in same tab)', 'amwerk' ) => '_self',
						esc_html__( 'Blank (open in new tab)', 'amwerk' ) => '_blank'
					)
				),
				array( 'param_name' => 'hover_style', 'type' => 'dropdown', 'heading' => esc_html__( 'Mouse hover style', 'amwerk' ), 'group' => esc_html__( 'URL', 'amwerk' ),
					'value' => array(
						esc_html__( 'Simple', 'amwerk' ) => 'simple',
						esc_html__( 'Flip', 'amwerk' ) => 'flip',
						esc_html__( 'Zoom in', 'amwerk' ) => 'zoom-in',
						esc_html__( 'To grayscale', 'amwerk' ) => 'to-grayscale',
						esc_html__( 'From grayscale', 'amwerk' ) => 'from-grayscale',
						esc_html__( 'Zoom in to grayscale', 'amwerk' ) => 'zoom-in-to-grayscale',
						esc_html__( 'Zoom in from grayscale', 'amwerk' ) => 'zoom-in-from-grayscale',
						esc_html__( 'Scroll', 'amwerk' ) => 'scroll'
					)
				),
				array( 'param_name' => 'content_display', 'type' => 'dropdown', 'heading' => esc_html__( 'Show content', 'amwerk' ), 'description' => esc_html__( 'Add selected elements and show them over the image', 'amwerk' ), 'group' => esc_html__( 'Content', 'amwerk' ),
					'value' => array(
						esc_html__( 'Always', 'amwerk' ) => 'always',
						esc_html__( 'Show on hover', 'amwerk' ) => 'show-on-hover',
						esc_html__( 'Hide on hover', 'amwerk' ) => 'hide-on-hover'
					)
				),
				array( 'param_name' => 'content_background_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Content background color', 'amwerk' ), 'group' => esc_html__( 'Content', 'amwerk' ) ),
				array( 'param_name' => 'content_background_opacity', 'type' => 'textfield', 'heading' => esc_html__( 'Content background opacity (e.g. 0.4)', 'amwerk' ), 'group' => esc_html__( 'Content', 'amwerk' ) ),
				array( 'param_name' => 'content_align', 'type' => 'dropdown', 'heading' => esc_html__( 'Content Alignment', 'amwerk' ), 'group' => esc_html__( 'Content', 'amwerk' ),
					'value' => array(
						esc_html__( 'Middle', 'amwerk' ) => 'middle',
						esc_html__( 'Top', 'amwerk' ) => 'top',						
						esc_html__( 'Bottom', 'amwerk' ) => 'bottom'
					)
				),
				array( 'param_name' => 'remove_padding', 'type' => 'dropdown', 'heading' => esc_html__( 'Padding', 'amwerk' ), 'group' => esc_html__( 'Content', 'amwerk' ),
					'value' => array(
						esc_html__( 'Default', 'amwerk' ) => 'no',
						esc_html__( '0', 'amwerk' ) => 'yes',
						esc_html__( '10px', 'amwerk' ) => '10',
						esc_html__( '20px', 'amwerk' ) => '20',
						esc_html__( '30px', 'amwerk' ) => '30',
						esc_html__( '40px', 'amwerk' ) => '40',
						esc_html__( '50px', 'amwerk' ) => '50',
						esc_html__( '60px', 'amwerk' ) => '60',
						esc_html__( '70px', 'amwerk' ) => '70',
						esc_html__( '80px', 'amwerk' ) => '80',
						esc_html__( '90px', 'amwerk' ) => '90',
						esc_html__( '100px', 'amwerk' ) => '100'
					)
				),
				array( 'param_name' => 'fill_background_color', 'type' => 'dropdown', 'heading' => esc_html__( 'Fill background color', 'amwerk' ),'group' => esc_html__( 'Content', 'amwerk' ) ,
					'value' => array(
						esc_html__( 'Full', 'amwerk' ) => 'full',
						esc_html__( 'Match content height', 'amwerk' ) => 'match_content_height'
					)
				),
			)
		) );
	}
	static function hex2rgb( $hex ) {
		$hex = str_replace( '#', '', $hex );
		if ( strlen( $hex ) == 3 ) {
			$r = hexdec( substr( $hex, 0, 1 ) . substr( $hex, 0, 1 ) );
			$g = hexdec( substr( $hex, 1, 1 ) . substr( $hex, 1, 1 ) );
			$b = hexdec( substr( $hex, 2, 1 ) . substr( $hex, 2, 1 ) );
		} else {
			$r = hexdec( substr( $hex, 0, 2 ) );
			$g = hexdec( substr( $hex, 2, 2 ) );
			$b = hexdec( substr( $hex, 4, 2 ) );
		}
		$rgb = array( $r, $g, $b );
		return $rgb;
	}
}