<?php

class bt_bb_portfolio_slider extends BT_BB_Element {
	
	public $auto_play = '';
	
	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'number'				=> '',
			'category'				=> '',
			'size'   				=> '',
			'show_dots' 			=> '',
			'animation' 			=> '',
			'gap' 					=> '',
			'arrows_size' 			=> '',
			'pause_on_hover'     	=> '',
			'slides_to_show' 		=> '',
			'auto_play' 			=> '',
			'overflow'				=> '',
			'target'				=> '',
			'show_title'			=> '',
			'show_excerpt'			=> '',
			'active_dot_color'		=> '',
			'inactive_dot_color'	=> '',
			'slider_arrows_default_state_style'		=> '',			
		) ), $atts, $this->shortcode ) );
		
		wp_enqueue_script( 
			'bt_bb_portfolio_slider',
			get_template_directory_uri() . '/bold-page-builder/content_elements/bt_bb_portfolio_slider/bt_bb_portfolio_slider.js',
			array( 'jquery' )
		);
		
		$class = array( $this->shortcode );
		
		$slider_class = array( 'slick-slider' );
		
		if ( $el_class != '' ) {
			$class[] = $el_class;
		}
		
		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}
		
		if ( $gap != '' ) {
			$class[] = $this->prefix . 'gap' . '_' . $gap;
		}
		
		if ( $arrows_size != '' ) {
			$class[] = $this->prefix . 'arrows_size' . '_' . $arrows_size;
		}
		
		if ( $show_dots != '' ) {
			$class[] = $this->prefix . 'show_dots_' . $show_dots;
		}
		
		if ( $animation != '' ) {
			$class[] = $this->prefix . 'animation' . '_' . $animation;
		}
		if ( $overflow != '' ) {
			$class[] = $this->prefix . 'overflow' . '_' . $overflow;
		}		
		if ( $active_dot_color != '' ) {
			$class[] = $this->prefix . 'active_dot' . '_' . $active_dot_color;
		}
		if ( $inactive_dot_color != '' ) {
			$class[] = $this->prefix . 'inactive_dot' . '_' . $inactive_dot_color;
		}
		if ( $slider_arrows_default_state_style != '' ) {
			$class[] = $this->prefix . 'slider_arrows' . '_' . $slider_arrows_default_state_style;
		}	
		
		$data_slick  = ' data-slick=\'{ "lazyLoad": "progressive", "cssEase": "ease-out", "speed": "600"';
		
		if ( $animation == 'fade' ) {
			$data_slick .= ', "fade": true';
			$slider_class[] = 'fade';
			$slides_to_show = 1;
		}
		
		if ( $arrows_size != 'no_arrows' ) {
			$data_slick  .= ', "prevArrow": "&lt;button type=\"button\" class=\"slick-prev\" aria-label=\"' . esc_html__( 'Previous', 'amwerk' ) . '\" tabindex=\"0\" role=\"button\"&gt;&lt;/button&gt;", "nextArrow": "&lt;button type=\"button\" class=\"slick-next\" aria-label=\"' . esc_html__( 'Next', 'amwerk' ) . '\" tabindex=\"0\" role=\"button\"&gt;&lt;/button&gt;"';
		} else {
			$data_slick .= ', "arrows": false';
		}
		
		$data_slick .= ', "adaptiveHeight": true';		
		
		if ( $show_dots != 'hide' ) {
			$data_slick .= ', "dots": true' ;
		}
		
		if ( $slides_to_show > 1 ) {
			$data_slick .= ',"slidesToShow": ' . intval( $slides_to_show );
			$class[] = $this->prefix . 'multiple_slides';
		}
		
		if ( $auto_play != '' ) {
			$data_slick .= ',"autoplay": true, "autoplaySpeed": ' . intval( $auto_play );
		}
		
		if ( $pause_on_hover == 'no' ) {
			$data_slick .= ',"pauseOnHover": false';
		}

		if ( is_rtl() ) {
			$data_slick .= ', "rtl": true' ;
		}
				
		if ( $slides_to_show > 1 ) {
			$data_slick .= ', "responsive": [';
			if ( $slides_to_show > 1 ) {
				$data_slick .= '{ "breakpoint": 480, "settings": { "slidesToShow": 1, "slidesToScroll": 1 } }';	
			}
			if ( $slides_to_show > 2 ) {
				$data_slick .= ',{ "breakpoint": 768, "settings": { "slidesToShow": 2, "slidesToScroll": 2 } }';	
			}
			if ( $slides_to_show > 3 ) {
				$data_slick .= ',{ "breakpoint": 920, "settings": { "slidesToShow": 3, "slidesToScroll": 3 } }';	
			}
			if ( $slides_to_show > 4 ) {
				$data_slick .= ',{ "breakpoint": 1024, "settings": { "slidesToShow": 3, "slidesToScroll": 3 } }';	
			}				
			$data_slick .= ']';
		}
		$data_slick = $data_slick . '}\' ';
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		
		$show = array( 'title' => false, 'excerpt' => false,   'target' => '_self', 'size' => 'large' );
		
		if ( $show_title == 'show_title' ) {
			$show['title'] = true;
		}
		if ( $show_excerpt == 'show_excerpt' ) {
			$show['excerpt'] = true;
		}
		if ( $target != '' ) {
			$show['target'] = $target;
		}
		if ( $size != '' ) {
			$show['size'] = $size;
		}
		
		if ( $number > 1000 || $number == '' ) {
			$number = 1000;
		} else if ( $number < 1 ) {
			$number = 1;
		}
		
		$posts = bt_bb_get_posts( $number, 0, $category, 'portfolio' );		
		
		$output = '<div' . $id_attr . ' class="' . implode( ' ', $class ) . '"' . $style_attr . ' data-slides="' . esc_attr( $slides_to_show ) . '"><div class="' . implode( ' ', $slider_class ) . '" ' . $data_slick .  '>' . $this->slider_content($posts, $show) . '</div></div>';	
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );
		
		return $output;	
	}
	
	static function slider_content($posts, $show){
		$output = '';
		$class	= array();	
		
		$prefix         = 'bt_bb_';
		$shortcode      = 'bt_bb_portfolio_slider';
		
		foreach( $posts as $item ) {
				$post_thumbnail_id = get_post_thumbnail_id( $item['ID'] ); 
				$img = wp_get_attachment_image_src( $post_thumbnail_id, $show['size'] );
				$img_src = isset($img[0]) ? $img[0] : BoldThemes_Customize_Default::$data['pf_slider_image_default'];			
				$hw = '100%';
				if ( $img_src ) {
					$style_attr = ' ';
				}else{
					$class[] = ' bt_bb_grid_item_inner_content_no_image';
					$style_attr = ' ';

					$pf_slider_image_default_id = attachment_url_to_postid( boldthemes_get_option( 'pf_slider_image_default' ) );
					if ( is_numeric( $pf_slider_image_default_id ) ) {
						$img = wp_get_attachment_image_src( $pf_slider_image_default_id, $show['size'] );
						$img_src = isset($img[0]) ? $img[0] : BoldThemes_Customize_Default::$data['pf_slider_image_default'];
					}
				}
			
				$alt = get_post_meta( $post_thumbnail_id, '_wp_attachment_image_alt', true );
				$alt = $alt != '' ? $alt : $item['title'];
			
				$output .= '<div class="bt_bb_grid_item" data-hw="' . esc_attr( $hw ) . '" data-src="' . esc_url_raw( $img_src ) . '" data-alt="' . esc_attr( $alt ) . '"' . $style_attr . '><div class="bt_bb_grid_item_inner' . esc_attr( implode( ' ', $class ) ) . '">';
					$output .= '<div class="bt_bb_grid_item_post_thumbnail">'
								. '<a href="' . esc_url_raw( $item['permalink'] ) . '" target="' . esc_attr( $show['target'] ) . '" title="' . esc_attr( $item['title'] ) . '">'
									. '<img class="bt_bb_grid_item_inner_image" src="' . esc_url_raw( $img_src ) . '" alt="' . esc_attr( $item['title'] ) . '" title="' . esc_attr( $item['title'] ) . '"/>'
								. '</a>'
							. '</div>';
					$output .= '<div class="bt_bb_grid_item_inner_content' . esc_attr( implode( ' ', $class ) ) . '"><div class="arrow"></div>';								
										
										$output .= '<div class="bt_bb_grid_item_inner_content_wrapper">'
												. '<h5 class="bt_bb_grid_item_post_title">'
													. '<a href="' . esc_url_raw( $item['permalink'] ) . '" title="' . esc_attr( $item['title'] ) . '">' . $item['title'] . '</a>'
												. '</h5>';						
												if ( $show['excerpt'] ) {
													$output .= '<div class="bt_bb_grid_item_post_excerpt">' . $item['excerpt'] . '</div>';
												}
										$output .= '</div>'
									
								. '</div>';
						if ( $show['title'] ) {
							$output .= '<div class="bt_bb_grid_item_post_title_init"><h5>' . $item['title'] . '</h5></div>';
						}
					$output .= '</div>';
				$output .= '</div>';

		}
		
		return $output;
	}
	
	function map_shortcode() {
		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Portfolio Slider', 'amwerk' ), 'description' => esc_html__( 'Slider with posts', 'amwerk' ), 'container' => 'vertical',  'toggle' => true, 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'number', 'type' => 'textfield', 'heading' => esc_html__( 'Number of items', 'amwerk' ), 'description' => esc_html__( 'Enter number of items or leave empty to show all (up to 1000)', 'amwerk' ), 'preview' => true ),
				array( 'param_name' => 'category', 'type' => 'textfield', 'heading' => esc_html__( 'Category', 'amwerk' ), 'description' => esc_html__( 'Enter category slug or leave empty to show all', 'amwerk' ), 'preview' => true ),
				array( 'param_name' => 'size', 'type' => 'dropdown', 'heading' => esc_html__( 'Size', 'amwerk' ), 'preview' => true,
					'value' => bt_bb_get_image_sizes()
				),
				array( 'param_name' => 'animation', 'type' => 'dropdown', 'heading' => esc_html__( 'Animation', 'amwerk' ), 'description' => esc_html__( 'If fade is selected, number of slides to show will be 1', 'amwerk' ),
					'value' => array(
						esc_html__( 'Default', 'amwerk' ) => 'slide',
						esc_html__( 'Fade', 'amwerk' ) => 'fade'
					)
				),
				array( 'param_name' => 'arrows_size', 'type' => 'dropdown', 'preview' => true, 'default' => 'normal', 'heading' => esc_html__( 'Navigation arrows size', 'amwerk' ),
					'value' => array(
						esc_html__( 'No arrows', 'amwerk' ) => 'no_arrows',
						esc_html__( 'Small', 'amwerk' ) => 'small',
						esc_html__( 'Normal', 'amwerk' ) => 'normal',
						esc_html__( 'Large', 'amwerk' ) => 'large'
					)
				),
				array( 'param_name' => 'show_dots', 'type' => 'dropdown', 'heading' => esc_html__( 'Dots navigation', 'amwerk' ),
					'value' => array(
						esc_html__( 'Bottom', 'amwerk' ) => 'bottom',
						esc_html__( 'Below', 'amwerk' ) => 'below',
						esc_html__( 'Hide', 'amwerk' ) => 'hide'
					)
				),
				array( 'param_name' => 'pause_on_hover', 'default' => 'yes', 'type' => 'dropdown', 'heading' => esc_html__( 'Pause slideshow on hover', 'amwerk' ),
					'value' => array(
						esc_html__( 'Yes', 'amwerk' ) => 'yes',
						esc_html__( 'No', 'amwerk' ) => 'no'
					)
				),
				array( 'param_name' => 'slides_to_show', 'type' => 'textfield', 'preview' => true, 'default' => 1, 'heading' => esc_html__( 'Number of slides to show', 'amwerk' ), 'description' => esc_html__( 'e.g. 3', 'amwerk' ) ),
				array( 'param_name' => 'gap', 'type' => 'dropdown', 'heading' => esc_html__( 'Gap', 'amwerk' ),
					'value' => array(
						esc_html__( 'No gap', 'amwerk' ) => 'no_gap',
						esc_html__( 'Small', 'amwerk' ) => 'small',
						esc_html__( 'Normal', 'amwerk' ) => 'normal',
						esc_html__( 'Large', 'amwerk' ) => 'large'
					)
				),
				array( 'param_name' => 'auto_play', 'type' => 'textfield', 'heading' => esc_html__( 'Autoplay interval (ms)', 'amwerk' ), 'description' => esc_html__( 'e.g. 2000', 'amwerk' ) ),
				array( 'param_name' => 'overflow', 'type' => 'dropdown', 'heading' => esc_html__( 'Overflow elements', 'amwerk' ), 
					'value' => array(
						esc_html__( 'Yes', 'amwerk' ) => 'yes',
						esc_html__( 'No', 'amwerk' ) => 'no'
					)
				),
				array( 'param_name' => 'show_title', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'amwerk' ) => 'show_title' ), 'heading' => esc_html__( 'Show title', 'amwerk' ), 'group' => esc_html__( 'Show', 'amwerk' ), 'preview' => true 
				),
				array( 'param_name' => 'show_excerpt', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'amwerk' ) => 'show_excerpt' ), 'heading' => esc_html__( 'Show excerpt', 'amwerk' ),'group' => esc_html__( 'Show', 'amwerk' ), 'preview' => true
				),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'heading' => esc_html__( 'Target', 'amwerk' ),'group' => esc_html__( 'Show', 'amwerk' ),
					'value' => array(
						esc_html__('Self (open in same tab)', 'amwerk' ) => '_self',
						esc_html__('Blank (open in new tab)', 'amwerk' ) => '_blank',
					)
				),
				array( 'param_name' => 'active_dot_color', 'type' => 'dropdown', 'heading' => esc_html__( 'Active dot color', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ),
					'value' => array(
						esc_html__( 'Accent', 'amwerk' ) => 'accent',
						esc_html__( 'Alternate', 'amwerk' ) => 'alternate'
					)
				),
				array( 'param_name' => 'inactive_dot_color', 'type' => 'dropdown', 'heading' => esc_html__( 'Inactive dot color', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ),
					'value' => array(
						esc_html__( 'Light font', 'amwerk' ) => 'light_font',
						esc_html__( 'Dark font', 'amwerk' ) => 'dark_font',
						esc_html__( 'Transparent light font', 'amwerk' ) => 'transparent_light_font',
						esc_html__( 'Transparent dark font', 'amwerk' ) => 'transparent_dark_font'
					)
				),
				array( 'param_name' => 'slider_arrows_default_state_style', 'type' => 'dropdown', 'heading' => esc_html__( 'Slider arrows default state style', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ),
					'value' => array(
						esc_html__( 'Dark font on light background', 'amwerk' ) => 'dark_font_light_bg',
						esc_html__( 'Light font on dark background', 'amwerk' ) => 'light_font_dark_bg',
						esc_html__( 'Dark font on transparent background', 'amwerk' ) => 'dark_font_transparent_bg',
						esc_html__( 'Light font on transparent background', 'amwerk' ) => 'light_font_transparent_bg'
					)
				),
			)
		) );
	}
}
