<?php

class bt_bb_price_list extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'title'        => '',
			'subtitle'     => '',
			'image'        => '',
			'size'         => '',
			'currency'     => '',
			'price'        => '',			
			'items'        => '',
			'color_scheme' => '',
			'button_text'				=> '',
			'button_style'				=> '',
			'button_color_scheme'		=> '',
			'url'						=> '',
			'currency_after'			=> '',
			'content_background_color'	=> ''			
		) ), $atts, $this->shortcode ) );
		
		if ( $url == '' ) {
			$url = '#';
		}

		$class = array( $this->shortcode );	

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}
		
		$style_attr = '';		
		if ( $el_style != '' || $content_background_color != '' ) {
			$style_attr .= ' ' . 'style="';
		}
		
		if ( $el_style != '' ) {
			$style_attr .= esc_attr( $el_style );
		}
		
		if ( $content_background_color != '' ) {
			$content_background_color_arr = bt_bb_image::hex2rgb( $content_background_color );
			$content_background_opacity = 1;			
			$style_attr .= 'background-color: rgba(' . $content_background_color_arr[0] . ', ' . $content_background_color_arr[1] . ', ' . $content_background_color_arr[2] . ', ' . $content_background_opacity . ') !important;';
		}
		
		if ( $el_style != '' || $content_background_color != '' ) {
			$style_attr .= '"';
		}
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		
		$output = '';
		
		if ( $image != '' ) {
			$output .=  '<div class="' . esc_attr( $this->shortcode . '_image') . '">' . do_shortcode( '[bt_bb_image image="' . esc_attr( $image ) . '" size="' . esc_attr( $size ) . '" url="' . esc_attr( $url ) . '" target="_self"  caption="' . esc_attr( $title ) . '"]' ) . '</div>';	
		}
		
		if ( $currency_after == 'yes' ){			
			$output .= '<div class="' . esc_attr( $this->shortcode ) . '_price ' . esc_attr( $this->shortcode ) . '_currency_after"' . $style_attr . '><span class="' . esc_attr( $this->shortcode ) . '_amount">' . $price . '</span><span class="' . esc_attr( $this->shortcode ) . '_currency">' . $currency . '</span></div>';

		}else{
			$output .= '<div class="' . esc_attr( $this->shortcode ) . '_price" ' . $style_attr . '><span class="' . esc_attr( $this->shortcode ) . '_currency">' . $currency . '</span><span class="' . esc_attr( $this->shortcode ) . '_amount">' . $price . '</span></div>';
		}

		$output .= '<div class="' . esc_attr( $this->shortcode ) . '_title">' . $title . '</div>';
		$output .= '<div class="' . esc_attr( $this->shortcode ) . '_subtitle">' . $subtitle . '</div>';
		
		if ( $items != '' ) {                    
			if ( function_exists( 'amwerk_get_price_list_items' ) ) {
				$items_arr = amwerk_get_price_list_items( $items );
				$output .= '<ul>';
					foreach ( $items_arr as $item ) {
						$output .= '<li>' . $item . '</li>';
					}
				$output .= '</ul>';
			}
		}
		
		$output .=  '<div class="' . esc_attr( $this->shortcode . '_button') . '">' . do_shortcode( '[bt_bb_button text="' . esc_attr( $button_text ) . '" color_scheme="'.esc_attr( $button_color_scheme ).'" url="' . esc_attr( $url ) . '" style="' . esc_attr( $button_style ) . ' bt_bb_size_small"]' ) . '</div>';
				
		if ( $color_scheme != '' ) {
			$class[] = $this->prefix . 'color_scheme_' . bt_bb_get_color_scheme_id( $color_scheme );
		}

		$output = '<div' . $id_attr . ' class="' . implode( ' ', $class ) . '"' . $style_attr . '>' . $output . '</div>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}

	function map_shortcode() {
		
		require_once( WP_PLUGIN_DIR   . '/bold-page-builder/content_elements_misc/misc.php' );
		$color_scheme_arr = bt_bb_get_color_scheme_param_array();			
		
		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Price List', 'amwerk' ), 'description' => esc_html__( 'List of items with total price', 'amwerk' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'title', 'type' => 'textfield', 'heading' => esc_html__( 'Title', 'amwerk' ), 'preview' => true ),
				array( 'param_name' => 'subtitle', 'type' => 'textfield', 'heading' => esc_html__( 'Subtitle', 'amwerk' ) ),
				array( 'param_name' => 'image', 'type' => 'attach_image', 'preview' => true, 'heading' => esc_html__( 'Image', 'amwerk' ) 
				),
				array( 'param_name' => 'size', 'type' => 'dropdown', 'heading' => esc_html__( 'Image Size', 'amwerk' ), 'preview' => true,
					'value' => bt_bb_get_image_sizes()
				),
				array( 'param_name' => 'currency', 'type' => 'textfield', 'heading' => esc_html__( 'Currency', 'amwerk' ) ),
				array( 'param_name' => 'currency_after', 'type' => 'dropdown', 'default' => 'no', 'heading' => esc_html__( 'Currency after price', 'amwerk' ),
					'value' => array(
						esc_html__( 'No', 'amwerk' ) 	=> 'no',
						esc_html__( 'Yes', 'amwerk' ) 	=> 'yes'
					)
				),
				array( 'param_name' => 'price', 'type' => 'textfield', 'heading' => esc_html__( 'Price', 'amwerk' ) ),				
				array( 'param_name' => 'items', 'type' => 'textarea_object', 'heading' => esc_html__( 'Items', 'amwerk' ) ),
				array( 'param_name' => 'button_text', 'type' => 'textfield', 'heading' => esc_html__( 'Button text', 'amwerk' ), 'group' => esc_html__( 'Button', 'amwerk' ),'preview' => true ),
				array( 'param_name' => 'button_style', 'type' => 'dropdown', 'heading' => esc_html__( 'Button style', 'amwerk' ), 'group' => esc_html__( 'Button', 'amwerk' ),
					'value' => array(
						esc_html__( 'Outline', 'amwerk' ) => 'outline',
						esc_html__( 'Filled', 'amwerk' ) => 'filled',
						esc_html__( 'Clean', 'amwerk' ) => 'clean',
						esc_html__( 'Underlined', 'amwerk' ) => 'underlined',
						esc_html__( 'With Huge Icon', 'amwerk' ) => 'with_huge_icon'
					)
				),
				array( 'param_name' => 'button_color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Button color scheme', 'amwerk' ), 'value' => $color_scheme_arr, 'group' => esc_html__( 'Button', 'amwerk' ) ),
				array( 'param_name' => 'url', 'type' => 'textfield', 'heading' => esc_html__( 'URL', 'amwerk' ), 'description' => esc_html__( 'Enter full or local URL (eg. https://www.bold-themes.com or /pages/about-us) or post slug (eg. about-us)', 'amwerk' ), 'group' => esc_html__( 'Button', 'amwerk' ) ),
				array( 'param_name' => 'content_background_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Background color', 'amwerk' ) ),
				array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Color scheme', 'amwerk' ), 'value' => $color_scheme_arr, 'preview' => true ),			
			)
		) );
	}
}