<?php

class bt_bb_section extends BT_BB_Element {
    
        function  bb_exist(){
            if ( file_exists( WP_PLUGIN_DIR . '/bold-page-builder/bold-builder.php' ) ) { return true; }
            return false;
        }

	function handle_shortcode( $atts, $content ) {
                if ( !$this->bb_exist() ) { return false; }
            
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'layout'                	=> '',
			'full_screen'           	=> '',
			'vertical_align'        	=> '',
			'top_spacing'           	=> '',
			'bottom_spacing'        	=> '',
			'negative_margin'        	=> '',
			'color_scheme'          	=> '',
			'background_color'      	=> '',
			'background_image'      	=> '',
			'lazy_load'					=> 'no',
			'background_overlay'    	=> '',
			'background_video_yt'   	=> '',
			'yt_video_settings'     	=> '',
			'background_video_mp4'  	=> '',
			'background_video_ogg'  	=> '',
			'background_video_webm' 	=> '',
			'show_video_on_mobile' 		=> '',
			'parallax'              	=> '',
			'parallax_offset'       	=> '',
			'background_position'    	=> '',
			'background_size'               => '',
			'top_section_coverage_image'    => '',
			'bottom_section_coverage_image' => '',
			'allow_content_outside'         => 'no'
		) ), $atts, $this->shortcode ) );

		$class = array( $this->shortcode );

		wp_enqueue_script(
			'bt_bb_elements',
			 plugins_url() . '/bold-page-builder/content_elements/bt_bb_section/bt_bb_elements.js',
			 array( 'jquery' ),
			 '',
			 true
		);

		$show_video_on_mobile = ( $show_video_on_mobile == 'show_video_on_mobile' || $show_video_on_mobile == 'yes' ) ? 1 : 0;

		if ( $top_spacing != '' ) {
			$class[] = $this->prefix . 'top_spacing' . '_' . $top_spacing;
		}

		if ( $bottom_spacing != '' ) {
			$class[] = $this->prefix . 'bottom_spacing' . '_' . $bottom_spacing;
		}
		
		if ( $negative_margin != '' ) {
			$class[] = $this->prefix . 'negative_margin' . '_' . $negative_margin;
		}

		if ( $color_scheme != '' ) {
			$class[] = $this->prefix . 'color_scheme_' . bt_bb_get_color_scheme_id( $color_scheme );
		}
		
		if ( $background_color != '' ) {
			$el_style = $el_style . ';' . 'background-color:' . $background_color . ';';
		}

		if ( $layout != '' ) {
			$class[] = $this->prefix . 'layout' . '_' . $layout;
		}

		if ( $full_screen == 'yes' ) {
			$class[] = $this->prefix . 'full_screen';
		}

		if ( $vertical_align != '' ) {
			$class[] = $this->prefix . 'vertical_align' . '_' . $vertical_align;
		}

		$data_parallax_attr = '';
		if ( $parallax != '' && ! wp_is_mobile() ) {
			$data_parallax_attr = 'data-parallax="' . esc_attr( $parallax ) . '" data-parallax-offset="' . esc_attr( intval( $parallax_offset ) ) . '"';
			$class[] = $this->prefix . 'parallax';
		}
		$background_data_attr = '';

		if ( $background_image != '' ) {
			$background_image = wp_get_attachment_image_src( $background_image, 'full' );
			$background_image_url = $background_image ? $background_image[0] : '';
			if ( $lazy_load == 'yes' ) {
				$blank_image_src = BT_BB_Root::$path . 'img/blank.gif';
				$background_image_style = 'background-image:url(\'' . $blank_image_src . '\');';
				$background_data_attr .= ' data-background_image_src="\'' . $background_image_url . '\'"';
				$class[] = 'btLazyLoadBackground';
			} else {
				$background_image_style = 'background-image:url(\'' . $background_image_url . '\');';
				
			}
			$el_style = $background_image_style . $el_style;	
			$class[] = $this->prefix . 'background_image';
		}

		if ( $background_overlay != '' ) {
			$class[] = $this->prefix . 'background_overlay' . '_' . $background_overlay;
		}

		$id_attr = '';
		if ( $el_id == '' ) {
			$el_id = uniqid( 'bt_bb_section' );
		}
		$id_attr = 'id="' . esc_attr( $el_id ) . '"';

		$background_video_attr = '';

		$video_html = '';

		if ( $background_video_yt != '' ) {
			wp_enqueue_style( 'bt_bb_style_yt', plugins_url() . '/bold-page-builder/content_elements/bt_bb_section/YTPlayer.css' );
			wp_enqueue_script( 
				'bt_bb_yt',
				plugins_url() . '/bold-page-builder/content_elements/bt_bb_section/jquery.mb.YTPlayer.min.js',
				array( 'jquery' ),
				'',
				true
			);

			$class[] = $this->prefix . 'background_video_yt';

			if ( $yt_video_settings == '' ) {
				$yt_video_settings = 'showControls:false,showYTLogo:false,mute:true,stopMovieOnBlur:false,opacity:1';
			}

			$yt_video_settings .= $show_video_on_mobile ? ',useOnMobile:true' : ',useOnMobile:false';

			$yt_video_settings .= '';

			$background_video_attr = ' ' . 'data-property="{videoURL:\'' . $background_video_yt . '\',containment:\'self\',' . $yt_video_settings . '}"';
			$proxy = new BT_BB_YT_Video_Proxy( $this->prefix );
			add_action( 'wp_footer', array( $proxy, 'js_init' ) );

		} else if ( ( $background_video_mp4 != '' || $background_video_ogg != '' || $background_video_webm != '' ) ) {
			$class[] = $this->prefix . 'video';
			$video_html = '<video autoplay loop muted onplay="bt_bb_video_callback( this )">';
			if ( $background_video_mp4 != '' ) {
				$video_html .= '<source src="' . esc_url_raw( $background_video_mp4 ) . '" type="video/mp4">';
			}
			if ( $background_video_ogg != '' ) {
				$video_html .= '<source src="' . esc_url_raw( $background_video_ogg ) . '" type="video/ogg">';
			}
			if ( $background_video_webm != '' ) {
				$video_html .= '<source src="' . esc_url_raw( $background_video_webm ) . '" type="video/webm">';
			}
			$video_html .= '</video>';
		}

		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		$class_attr = implode( ' ', $class );

		if ( $el_class != '' ) {
			$class_attr = $class_attr . ' ' . $el_class;
		}                   
                
		if ( $allow_content_outside == 'yes' ) {
				$class_attr = $class_attr . ' ' . $this->shortcode . '_allow_content_outside';
		}

		$top_section_coverage_image_output = '';
		if ( $top_section_coverage_image != '' ) { 
			$alt_top_section_coverage_image = get_post_meta($top_section_coverage_image, '_wp_attachment_image_alt', true);
			$alt_top_section_coverage_image = $alt_top_section_coverage_image ? $alt_top_section_coverage_image : $this->shortcode . '_top_section_coverage_image';

			$top_section_coverage_image = wp_get_attachment_image_src( $top_section_coverage_image, 'full' );                     
			if ( isset($top_section_coverage_image[0]) ){
				$class_attr = $class_attr . ' ' . $this->shortcode . '_with_top_coverage_image';
				$top_section_coverage_image = $top_section_coverage_image[0];
				$top_section_coverage_image_output = 
						'<div class="' . esc_attr( $this->shortcode ) . '_top_section_coverage_image">'
							. '<img src="' . esc_url_raw($top_section_coverage_image) . '" alt="' . esc_attr($alt_top_section_coverage_image) . '" />'
						. '</div>';
			}
		}
		$bottom_section_coverage_image_output = '';
		if ( $bottom_section_coverage_image != '' ) {  
			$alt_bottom_section_coverage_image = get_post_meta($bottom_section_coverage_image, '_wp_attachment_image_alt', true);
			$alt_bottom_section_coverage_image = $alt_bottom_section_coverage_image ? $alt_bottom_section_coverage_image : $this->shortcode . '_bottom_section_coverage_image';

			$bottom_section_coverage_image = wp_get_attachment_image_src( $bottom_section_coverage_image, 'full' );
			if ( isset($bottom_section_coverage_image[0]) ){
				$class_attr = $class_attr . ' ' .$this->shortcode . '_with_bottom_coverage_image';
				$bottom_section_coverage_image = $bottom_section_coverage_image[0];                    
				$bottom_section_coverage_image_output = 
						'<div class="' . esc_attr( $this->shortcode ) . '_bottom_section_coverage_image">'
							. '<img src="' . esc_url_raw($bottom_section_coverage_image) . '" alt="' . esc_attr($alt_bottom_section_coverage_image) . '" />'
						. '</div>';
			}
		}

		$background_position_style  = $background_position  != '' ? 'background-position:' . $background_position . ';' : '';
		$background_size_style      = $background_size      != '' ? 'background-size:' . $background_size . ';' : '';

		$style_attr = '';
		if ( $el_style != '' || $background_position_style != '' || $background_size_style != '' ) {
			$style_attr = 'style="' . esc_attr( $el_style . $background_position_style . $background_size_style ) . '"';
		}  

		$output = '<section ' . $id_attr . ' ' . $data_parallax_attr . $background_data_attr . ' class="' . esc_attr( $class_attr ) . '" ' . $style_attr . $background_video_attr . '>';
		$output .= $video_html;
		$output .= '<div class="' . esc_attr( $this->prefix ) . 'port">';
		$output .= '<div class="' . esc_attr( $this->prefix ) . 'cell">';
		$output .= '<div class="' . esc_attr( $this->prefix ) . 'cell_inner">';
		$output .= do_shortcode( $content );
		$output .= '</div>';
		$output .= '</div>';
		$output .= '</div>';
		$output .= $top_section_coverage_image_output;
		$output .= $bottom_section_coverage_image_output;
		$output .= '</section>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}

	function map_shortcode() {
		if ( !$this->bb_exist() ) { return false; }
		require_once( WP_PLUGIN_DIR   . '/bold-page-builder/content_elements_misc/misc.php' );
		$color_scheme_arr = bt_bb_get_color_scheme_param_array();

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Section', 'amwerk' ), 'description' => esc_html__( 'Basic root element', 'amwerk' ), 'root' => true, 'container' => 'vertical', 'accept' => array( 'bt_bb_row' => true ), 'toggle' => true, 'auto_add' => 'bt_bb_row', 'show_settings_on_create' => false,
			'params' => array( 
				array( 'param_name' => 'layout', 'type' => 'dropdown', 'default' => 'boxed_1200', 'heading' => esc_html__( 'Layout', 'amwerk' ), 'group' => esc_html__( 'General', 'amwerk' ), 'weight' => 0, 'preview' => true,
					'value' => array(
						esc_html__( 'Boxed (800px)', 'amwerk' ) => 'boxed_800',
						esc_html__( 'Boxed (900px)', 'amwerk' ) => 'boxed_900',
						esc_html__( 'Boxed (1000px)', 'amwerk' ) => 'boxed_1000',
						esc_html__( 'Boxed (1100px)', 'amwerk' ) => 'boxed_1100',
						esc_html__( 'Boxed (1200px)', 'amwerk' ) => 'boxed_1200',
						esc_html__( 'Boxed (1300px)', 'amwerk' ) => 'boxed_1300',
						esc_html__( 'Boxed (1400px)', 'amwerk' ) => 'boxed_1400',
						esc_html__( 'Boxed (1500px)', 'amwerk' ) => 'boxed_1500',
						esc_html__( 'Boxed (1600px)', 'amwerk' ) => 'boxed_1600',
						esc_html__( 'Wide', 'amwerk' ) => 'wide'
					)
				),
				array( 'param_name' => 'top_spacing', 'type' => 'dropdown', 'heading' => esc_html__( 'Top spacing', 'amwerk' ), 'preview' => true,
					'value' => array(
						esc_html__( 'No spacing', 'amwerk' ) 	=> '',
						esc_html__( 'Extra small', 'amwerk' ) 	=> 'extra_small',
						esc_html__( 'Small', 'amwerk' ) 		=> 'small',		
						esc_html__( 'Normal', 'amwerk' ) 		=> 'normal',
						esc_html__( 'Medium', 'amwerk' ) 		=> 'medium',
						esc_html__( 'Large', 'amwerk' ) 		=> 'large',
						esc_html__( 'Extra large', 'amwerk' ) 	=> 'extra_large',
						esc_html__( '5px', 'amwerk' ) 			=> '5',
						esc_html__( '10px', 'amwerk' ) 		=> '10',
						esc_html__( '15px', 'amwerk' ) 		=> '15',
						esc_html__( '20px', 'amwerk' ) 		=> '20',
						esc_html__( '25px', 'amwerk' ) 		=> '25',
						esc_html__( '30px', 'amwerk' ) 		=> '30',
						esc_html__( '35px', 'amwerk' ) 		=> '35',
						esc_html__( '40px', 'amwerk' ) 		=> '40',
						esc_html__( '45px', 'amwerk' ) 		=> '45',
						esc_html__( '50px', 'amwerk' ) 		=> '50',
						esc_html__( '55px', 'amwerk' ) 		=> '55',
						esc_html__( '60px', 'amwerk' ) 		=> '60',
						esc_html__( '65px', 'amwerk' ) 		=> '65',
						esc_html__( '70px', 'amwerk' ) 		=> '70',
						esc_html__( '75px', 'amwerk' ) 		=> '75',
						esc_html__( '80px', 'amwerk' ) 		=> '80',
						esc_html__( '85px', 'amwerk' ) 		=> '85',
						esc_html__( '90px', 'amwerk' ) 		=> '90',
						esc_html__( '95px', 'amwerk' ) 		=> '95',
						esc_html__( '100px', 'amwerk' ) 		=> '100'
					)
				),
				array( 'param_name' => 'bottom_spacing', 'type' => 'dropdown', 'heading' => esc_html__( 'Bottom spacing', 'amwerk' ), 'preview' => true,
					'value' => array(
						esc_html__( 'No spacing', 'amwerk' ) 	=> '',
						esc_html__( 'Extra small', 'amwerk' ) 	=> 'extra_small',
						esc_html__( 'Small', 'amwerk' ) 		=> 'small',		
						esc_html__( 'Normal', 'amwerk' ) 		=> 'normal',
						esc_html__( 'Medium', 'amwerk' ) 		=> 'medium',
						esc_html__( 'Large', 'amwerk' ) 		=> 'large',
						esc_html__( 'Extra large', 'amwerk' ) 	=> 'extra_large',
						esc_html__( '5px', 'amwerk' ) 			=> '5',
						esc_html__( '10px', 'amwerk' ) 		=> '10',
						esc_html__( '15px', 'amwerk' ) 		=> '15',
						esc_html__( '20px', 'amwerk' ) 		=> '20',
						esc_html__( '25px', 'amwerk' ) 		=> '25',
						esc_html__( '30px', 'amwerk' ) 		=> '30',
						esc_html__( '35px', 'amwerk' ) 		=> '35',
						esc_html__( '40px', 'amwerk' ) 		=> '40',
						esc_html__( '45px', 'amwerk' ) 		=> '45',
						esc_html__( '50px', 'amwerk' ) 		=> '50',
						esc_html__( '55px', 'amwerk' ) 		=> '55',
						esc_html__( '60px', 'amwerk' ) 		=> '60',
						esc_html__( '65px', 'amwerk' ) 		=> '65',
						esc_html__( '70px', 'amwerk' ) 		=> '70',
						esc_html__( '75px', 'amwerk' ) 		=> '75',
						esc_html__( '80px', 'amwerk' ) 		=> '80',
						esc_html__( '85px', 'amwerk' ) 		=> '85',
						esc_html__( '90px', 'amwerk' ) 		=> '90',
						esc_html__( '95px', 'amwerk' ) 		=> '95',
						esc_html__( '100px', 'amwerk' ) 		=> '100'
					)
				),
				array( 'param_name' => 'negative_margin', 'type' => 'dropdown', 'heading' => esc_html__( 'Negative margin', 'amwerk' ), 'group' => esc_html__( 'General', 'amwerk' ), 'weight' => 4, 'preview' => true,
				'value' => array(
						esc_html__( 'No margin', 'amwerk' ) 	=> '',
						esc_html__( 'Small', 'amwerk' ) 		=> 'small',
						esc_html__( 'Normal', 'amwerk' ) 		=> 'normal',
						esc_html__( 'Medium', 'amwerk' ) 		=> 'medium',
						esc_html__( 'Large', 'amwerk' ) 		=> 'large',
						esc_html__( 'Extra Large', 'amwerk' ) 	=> 'extralarge',
						esc_html__( '5px', 'amwerk' ) 			=> '5',
						esc_html__( '10px', 'amwerk' ) 		=> '10',
						esc_html__( '15px', 'amwerk' ) 		=> '15',
						esc_html__( '20px', 'amwerk' ) 		=> '20',
						esc_html__( '25px', 'amwerk' ) 		=> '25',
						esc_html__( '30px', 'amwerk' ) 		=> '30',
						esc_html__( '35px', 'amwerk' ) 		=> '35',
						esc_html__( '40px', 'amwerk' ) 		=> '40',
						esc_html__( '45px', 'amwerk' ) 		=> '45',
						esc_html__( '50px', 'amwerk' ) 		=> '50',
						esc_html__( '55px', 'amwerk' ) 		=> '55',
						esc_html__( '60px', 'amwerk' ) 		=> '60',
						esc_html__( '65px', 'amwerk' ) 		=> '65',
						esc_html__( '70px', 'amwerk' ) 		=> '70',
						esc_html__( '75px', 'amwerk' ) 		=> '75',
						esc_html__( '80px', 'amwerk' ) 		=> '80',
						esc_html__( '85px', 'amwerk' ) 		=> '85',
						esc_html__( '90px', 'amwerk' ) 		=> '90',
						esc_html__( '95px', 'amwerk' ) 		=> '95',
						esc_html__( '100px', 'amwerk' ) 		=> '100'
					)
				),
				array( 'param_name' => 'full_screen', 'type' => 'dropdown', 'heading' => esc_html__( 'Full screen', 'amwerk' ), 
					'value' => array(
						esc_html__( 'No', 'amwerk' ) => '',
						esc_html__( 'Yes', 'amwerk' ) => 'yes'
					)
				),
				array( 'param_name' => 'vertical_align', 'type' => 'dropdown', 'heading' => esc_html__( 'Vertical align (for fullscreen section)', 'amwerk' ), 'preview' => true,
					'value' => array(
						esc_html__( 'Top', 'amwerk' )     => 'top',
						esc_html__( 'Middle', 'amwerk' )  => 'middle',
						esc_html__( 'Bottom', 'amwerk' )  => 'bottom'					
					)
				),
				array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Color scheme', 'amwerk' ), 'value' => $color_scheme_arr, 'preview' => true, 'group' => esc_html__( 'Design', 'amwerk' )  ),
				array( 'param_name' => 'background_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Background color', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ), 'preview' => true ),
				array( 'param_name' => 'background_image', 'type' => 'attach_image',  'preview' => true, 'heading' => esc_html__( 'Background image', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ) ),
				array( 'param_name' => 'lazy_load', 'type' => 'dropdown', 'default' => 'yes', 'heading' => esc_html__( 'Lazy load background image', 'amwerk' ),
					'value' => array(
						esc_html__( 'No', 'amwerk' ) => 'no',
						esc_html__( 'Yes', 'amwerk' ) => 'yes'
					)
				),
				array( 'param_name' => 'background_overlay', 'type' => 'dropdown', 'heading' => esc_html__( 'Background overlay', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ), 
					'value' => array(
						esc_html__( 'No overlay', 'amwerk' )    => '',
						esc_html__( 'Light stripes', 'amwerk' ) => 'light_stripes',
						esc_html__( 'Dark stripes', 'amwerk' )  => 'dark_stripes',
						esc_html__( 'Light solid', 'amwerk' )	  => 'light_solid',
						esc_html__( 'Dark solid', 'amwerk' )	  => 'dark_solid',
						esc_html__( 'Accent solid', 'amwerk' )	  => 'accent_solid',
						esc_html__( 'Alternate solid', 'amwerk' )	  => 'alternate_solid',
						esc_html__( 'Light gradient', 'amwerk' )	  => 'light_gradient',
						esc_html__( 'Dark gradient', 'amwerk' )	  => 'dark_gradient',
						esc_html__( 'Accent gradient', 'amwerk' )	  => 'accent_gradient',
						esc_html__( 'Alternate gradient', 'amwerk' )	  => 'alternate_gradient'
					)
				),
				array( 'param_name' => 'background_position', 'type' => 'textfield', 'heading' => esc_html__( 'Background position in keywords (e.g. left, right, top, bottom, center) or in pixels / percentage - ineffective if parallax is used', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ) ),
				array( 'param_name' => 'background_size', 'type' => 'textfield', 'heading' => esc_html__( 'Background size (e.g. auto, cover, contain, initial, inherit or size in pixels - ineffective if parallax is used', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ) ),
				array( 'param_name' => 'top_section_coverage_image', 'type' => 'attach_image',  'preview' => true, 'heading' => esc_html__( 'Top Section Covering Image', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ) ),
				array( 'param_name' => 'bottom_section_coverage_image', 'type' => 'attach_image',  'preview' => true, 'heading' => esc_html__( 'Bottom Section Covering Image', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ) ),
			
				array( 'param_name' => 'allow_content_outside', 'type' => 'dropdown', 'default' => 'no', 'heading' => esc_html__( 'Show content over top or bottom covering image', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ),
					'value' => array(
							esc_html__( 'No (content to be underneath top and bottom covering image)', 'amwerk' ) => 'no',
							esc_html__( 'Yes (content will cover both covering images)', 'amwerk' ) => 'yes'
					)
				),				
				array( 'param_name' => 'parallax', 'type' => 'textfield', 'heading' => esc_html__( 'Parallax (e.g. 0.7)', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ) ),
				array( 'param_name' => 'parallax_offset', 'type' => 'textfield', 'heading' => esc_html__( 'Parallax offset in px (e.g. -100)', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ) ),
				array( 'param_name' => 'background_video_yt', 'type' => 'textfield', 'heading' => esc_html__( 'YouTube background video', 'amwerk' ), 'group' => esc_html__( 'Video', 'amwerk' ) ),
				array( 'param_name' => 'yt_video_settings', 'type' => 'textfield', 'heading' => esc_html__( 'YouTube video settings (e.g. startAt:20, mute:true, stopMovieOnBlur:false)', 'amwerk' ), 'group' => esc_html__( 'Video', 'amwerk' ) ),
				array( 'param_name' => 'background_video_mp4', 'type' => 'textfield', 'heading' => esc_html__( 'MP4 background video', 'amwerk' ), 'group' => esc_html__( 'Video', 'amwerk' ) ),
				array( 'param_name' => 'background_video_ogg', 'type' => 'textfield', 'heading' => esc_html__( 'OGG background video', 'amwerk' ), 'group' => esc_html__( 'Video', 'amwerk' ) ),
				array( 'param_name' => 'background_video_webm', 'type' => 'textfield', 'heading' => esc_html__( 'WEBM background video', 'amwerk' ), 'group' => esc_html__( 'Video', 'amwerk' ) ),
				array( 'param_name' => 'show_video_on_mobile',  'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'amwerk' ) => 'yes' ), 'default' => '', 'heading' => esc_html__( 'Show Video on Mobile Devices', 'amwerk' ), 'group' => esc_html__( 'Video', 'amwerk' ) )
			)
		) );		

	} 

}

class BT_BB_YT_Video_Proxy {
	function __construct( $prefix ) {
		$this->prefix = $prefix;
	}
	public function js_init() {
            wp_register_script( 'boldthemes-script-bt-bb-section-js-init', '' );
            wp_enqueue_script( 'boldthemes-script-bt-bb-section-js-init' );
            wp_add_inline_script( 'boldthemes-script-bt-bb-section-js-init', 'jQuery(function() { jQuery( ".' . esc_html($this->prefix) . 'background_video_yt" ).YTPlayer();});' );
        }
}