<?php
if ( class_exists( 'BoldThemesFramework' ) && isset( BoldThemesFramework::$crush_vars ) ) {
	$boldthemes_crush_vars = apply_filters( 'boldthemes_crush_vars', BoldThemesFramework::$crush_vars );
}
if ( class_exists( 'BoldThemesFramework' ) && isset( BoldThemesFramework::$crush_vars_def ) ) {
	$boldthemes_crush_vars_def = BoldThemesFramework::$crush_vars_def;
}
if ( isset( $boldthemes_crush_vars['accentColor'] ) ) {
	$accentColor = $boldthemes_crush_vars['accentColor'];
} else {
	$accentColor = "#f1b209";
}
if ( isset( $boldthemes_crush_vars['alternateColor'] ) ) {
	$alternateColor = $boldthemes_crush_vars['alternateColor'];
} else {
	$alternateColor = "#013989";
}
if ( isset( $boldthemes_crush_vars['bodyFont'] ) ) {
	$bodyFont = $boldthemes_crush_vars['bodyFont'];
} else {
	$bodyFont = "Assistant";
}
if ( isset( $boldthemes_crush_vars['menuFont'] ) ) {
	$menuFont = $boldthemes_crush_vars['menuFont'];
} else {
	$menuFont = "Assistant";
}
if ( isset( $boldthemes_crush_vars['headingFont'] ) ) {
	$headingFont = $boldthemes_crush_vars['headingFont'];
} else {
	$headingFont = "Assistant";
}
if ( isset( $boldthemes_crush_vars['headingSuperTitleFont'] ) ) {
	$headingSuperTitleFont = $boldthemes_crush_vars['headingSuperTitleFont'];
} else {
	$headingSuperTitleFont = "Assistant";
}
if ( isset( $boldthemes_crush_vars['headingSubTitleFont'] ) ) {
	$headingSubTitleFont = $boldthemes_crush_vars['headingSubTitleFont'];
} else {
	$headingSubTitleFont = "Assistant";
}
if ( isset( $boldthemes_crush_vars['logoHeight'] ) ) {
	$logoHeight = $boldthemes_crush_vars['logoHeight'];
} else {
	$logoHeight = "120";
}
$accentColorDark = CssCrush\fn__l_adjust( $accentColor." -15" );$accentColorVeryDark = CssCrush\fn__l_adjust( $accentColor." -35" );$accentColorVeryVeryDark = CssCrush\fn__l_adjust( $accentColor." -42" );$accentColorLight = CssCrush\fn__a_adjust( $accentColor." -30" );$alternateColorDark = CssCrush\fn__l_adjust( $alternateColor." -15" );$alternateColorVeryDark = CssCrush\fn__l_adjust( $alternateColor." -25" );$alternateColorLight = CssCrush\fn__a_adjust( $alternateColor." -40" );$css_override = sanitize_text_field("select,
input{font-family: \"{$bodyFont}\",Arial,Helvetica,sans-serif;}
input[type=\"file\"]::-webkit-file-upload-button{
    background: {$accentColor} !important;
    font-family: {$headingFont};}
input[type=\"checkbox\"]:before{
    background: {$accentColor};}
input[type=\"radio\"]:before{
    background: {$accentColor};}
.fancy-select ul.options li:after{
    background: {$accentColor};}
.bt-content article .btArticleContent a:not(.wp-block-button__link){color: {$accentColor};}
a:hover{
    color: {$accentColor};}
.btText a{color: {$accentColor};}
body{font-family: \"{$bodyFont}\",Arial,Helvetica,sans-serif;}
h1,
h2,
h3,
h4,
h5,
h6{font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
blockquote{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
blockquote:before{
    color: {$accentColor};}
.bt-content-holder table thead th{
    background-color: {$accentColor};}
.btSidebarAccentTopBorder.btWithSidebar .bt-content-holder .btSidebar{border-top: 10px solid {$accentColor};}
.btSidebarAlternateTopBorder.btWithSidebar .bt-content-holder .btSidebar{border-top: 10px solid {$alternateColor};}
.btAccentDarkHeader .btPreloader .animation > div:first-child,
.btLightAccentHeader .btPreloader .animation > div:first-child,
.btTransparentLightHeader .btPreloader .animation > div:first-child{
    background-color: {$accentColor};}
.btPreloader .animation .preloaderLogo{height: {$logoHeight}px;}
.btLoader:after{
    background: {$accentColor};}
body.error404 .bt-error-page .bt_bb_port .bt_bb_cell .bt_bb_headline_subheadline .bt_bb_button .bt_bb_link,
body.error404 .btErrorPage .bt_bb_port .bt_bb_cell .bt_bb_headline_subheadline .bt_bb_button .bt_bb_link{
    box-shadow: 0 0 0 2em {$accentColor} inset;}
body.error404 .bt-error-page .bt_bb_port .bt_bb_cell .bt_bb_headline_subheadline .bt_bb_button .bt_bb_link:hover,
body.error404 .btErrorPage .bt_bb_port .bt_bb_cell .bt_bb_headline_subheadline .bt_bb_button .bt_bb_link:hover{box-shadow: 0 0 0 2em {$accentColor} inset,0 5px 20px rgba(0,0,0,.2);}
.bt_bb_touch body.btBelowMenu .btPageHeadline .bt_bb_port{padding-top: calc(6em + {$logoHeight}px*0.6);}
.btPageHeadlineLightAccent .btPageHeadline:before{background: {$accentColor};}
.btPageHeadlineLightAccent .btPageHeadline.bt_bb_background_image:before{background: {$accentColor};}
.btPageHeadlineLightAccent .btPageHeadline .btArticleCategories:before,
.btPageHeadlineLightAccent .btPageHeadline .btArticleAuthor:before,
.btPageHeadlineLightAccent .btPageHeadline .btArticleDate:before,
.btPageHeadlineLightAccent .btPageHeadline .btArticleComments:before{color: {$alternateColor};}
.btPageHeadlineLightAccent .btPageHeadline .bt_bb_dash_top.bt_bb_headline .bt_bb_headline_superheadline:before{background: {$alternateColor};}
.btPageHeadlineDarkAccent .btPageHeadline:before{background: {$accentColor};}
.btPageHeadlineDarkAccent .btPageHeadline.bt_bb_background_image:before{background: {$accentColor};}
.btPageHeadlineLightAlternate .btPageHeadline:before{background: {$alternateColor};}
.btPageHeadlineLightAlternate .btPageHeadline.bt_bb_background_image:before{background: {$alternateColor};}
.btPageHeadlineLightAlternate .btPageHeadline .btArticleCategories:before,
.btPageHeadlineLightAlternate .btPageHeadline .btArticleAuthor:before,
.btPageHeadlineLightAlternate .btPageHeadline .btArticleDate:before,
.btPageHeadlineLightAlternate .btPageHeadline .btArticleComments:before{color: {$accentColor};}
.btPageHeadlineLightAlternate .btPageHeadline .bt_bb_dash_top.bt_bb_headline .bt_bb_headline_superheadline:before{background: {$accentColor};}
.btPageHeadlineDarkAlternate .btPageHeadline:before{background: {$alternateColor};}
.btPageHeadlineDarkAlternate .btPageHeadline.bt_bb_background_image:before{background: {$alternateColor};}
.btPageHeadlineDarkAlternate .btPageHeadline .btArticleCategories:before,
.btPageHeadlineDarkAlternate .btPageHeadline .btArticleAuthor:before,
.btPageHeadlineDarkAlternate .btPageHeadline .btArticleDate:before,
.btPageHeadlineDarkAlternate .btPageHeadline .btArticleComments:before{color: {$accentColor};}
.btPageHeadlineDarkAlternate .btPageHeadline .bt_bb_dash_top.bt_bb_headline .bt_bb_headline_superheadline:before{background: {$accentColor};}
.bt-no-search-results .bt_bb_port #searchform input[type='submit']{
    background: {$accentColor};}
.bt-no-search-results .bt_bb_port .bt_bb_button .bt_bb_icon_holder:before{color: {$accentColor};}
.mainHeader{
    font-family: \"{$menuFont}\",Arial,Helvetica,sans-serif;}
.mainHeader a:hover{color: {$accentColor};}
.menuPort{
    font-family: \"{$menuFont}\",Arial,Helvetica,sans-serif;}
.menuPort nav ul li a:hover{color: {$accentColor};}
.menuPort nav > ul > li > a{line-height: {$logoHeight}px;
    line-height: max(50px,{$logoHeight}px);}
.btTextLogo{
    font-family: \"{$menuFont}\",Arial,Helvetica,sans-serif;
    line-height: {$logoHeight}px;
    line-height: max(50px,{$logoHeight}px);}
.btMenuVertical .bt-vertical-header-top .btTextLogo{line-height: calc({$logoHeight}px*0.6);
    line-height: max(50px,calc({$logoHeight}px*0.6));}
.bt-logo-area .logo img{height: {$logoHeight}px;}
.bt-horizontal-menu-trigger{
    line-height: {$logoHeight}px;
    line-height: max(50px,{$logoHeight}px);}
.btStickyHeaderActive .bt-horizontal-menu-trigger{line-height: calc({$logoHeight}px*0.6);
    line-height: max(50px,calc({$logoHeight}px*0.6));}
.bt-horizontal-menu-trigger .bt_bb_icon{
    background: {$accentColor};}
.btMenuHorizontal .menuPort nav > ul > li > a:after{
    background: {$accentColor};}
.btMenuHorizontal .menuPort nav > ul > li > a:before{
    background: {$accentColor};}
.btMenuHorizontal .menuPort ul ul li > a:after{
    background-color: {$accentColor};}
body.btMenuHorizontal .subToggler{
    line-height: {$logoHeight}px;
    line-height: max(50px,{$logoHeight}px);}
.btMenuHorizontal .menuPort > nav > ul ul{
    top: calc({$logoHeight}px - ({$logoHeight}px - 50px)/2);
    top: max(50px,calc({$logoHeight}px - ({$logoHeight}px - 50px)/2));}
.btMenuHorizontal.btMenuCenter .logo{
    height: {$logoHeight}px;
    height: max(50px,{$logoHeight}px);}
.btStickyHeaderActive.btMenuHorizontal.btMenuCenter .logo{height: calc({$logoHeight}px*0.6);
    height: max(50px,calc({$logoHeight}px*0.6));}
html:not(.touch) body.btMenuHorizontal.btMenuRight .menuPort > nav > ul > li.btMenuWideDropdown > ul > li:last-child > a:after{
    background-color: {$accentColor};}
.btMenuHorizontal .topBarInMenu{
    height: {$logoHeight}px;
    height: max(50px,{$logoHeight}px);}
.btMenuHorizontal .topBarInMenu .topBarInMenuCell{line-height: {$logoHeight}px;
    line-height: max(50px,{$logoHeight}px);}
.btTransparentLightHeader.btBelowMenu .topBar .topTools .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:before{color: {$accentColor} !important;
    box-shadow: 0 0 {$accentColor} inset;}
.btTransparentLightHeader.btBelowMenu .topBar .topTools .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:hover:before{box-shadow: 0 -50px {$accentColor} inset;}
.btTransparentLightHeader.btBelowMenu .topBar .topTools .widget_shopping_cart .widget_shopping_cart_content.on .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:before{box-shadow: 0 -50px {$accentColor} inset;}
.btTransparentLightHeader.btBelowMenu .topBar .topTools .widget_search .btSearch .bt_bb_icon .bt_bb_icon_holder:before{color: {$accentColor} !important;
    box-shadow: 0 0 {$accentColor} inset;}
.btTransparentLightHeader.btBelowMenu .topBar .topTools .widget_search .btSearch .bt_bb_icon .bt_bb_icon_holder:hover:before{box-shadow: 0 -50px {$accentColor} inset;}
.btAccentLightHeader .bt-below-logo-area,
.btAccentLightHeader .topBar{background-color: {$accentColor};}
.btAccentLightHeader .bt-below-logo-area .btAccentIconWidget.btIconWidget .btIconWidgetIcon,
.btAccentLightHeader .topBar .btAccentIconWidget.btIconWidget .btIconWidgetIcon{color: {$alternateColor};}
.btAccentLightHeader .bt-below-logo-area a.btAccentIconWidget.btIconWidget:hover,
.btAccentLightHeader .bt-below-logo-area a.btIconWidget:hover,
.btAccentLightHeader .topBar a.btAccentIconWidget.btIconWidget:hover,
.btAccentLightHeader .topBar a.btIconWidget:hover{color: {$alternateColor};}
.btAccentDarkHeader .bt-below-logo-area,
.btAccentDarkHeader .topBar{background-color: {$accentColor};}
.btLightDarkHeader .bt-below-logo-area .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:before,
.btLightDarkHeader .topBar .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:before{color: {$accentColor};
    box-shadow: 0 0 {$accentColor} inset;}
.btLightDarkHeader .bt-below-logo-area .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:hover:before,
.btLightDarkHeader .topBar .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:hover:before{
    box-shadow: 0 -50px {$accentColor} inset;}
.btLightDarkHeader .bt-below-logo-area .widget_shopping_cart .widget_shopping_cart_content.on .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:before,
.btLightDarkHeader .topBar .widget_shopping_cart .widget_shopping_cart_content.on .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:before{box-shadow: 0 -50px {$accentColor} inset;}
.btLightDarkHeader .bt-below-logo-area .widget_search .btSearch .bt_bb_icon .bt_bb_icon_holder:before,
.btLightDarkHeader .topBar .widget_search .btSearch .bt_bb_icon .bt_bb_icon_holder:before{color: {$accentColor};
    box-shadow: 0 0 {$accentColor} inset;}
.btLightDarkHeader .bt-below-logo-area .widget_search .btSearch .bt_bb_icon .bt_bb_icon_holder:hover:before,
.btLightDarkHeader .topBar .widget_search .btSearch .bt_bb_icon .bt_bb_icon_holder:hover:before{
    box-shadow: 0 -50px {$accentColor} inset;}
.btLightDarkHeader .bt-below-logo-area a.btAccentIconWidget.btIconWidget:hover,
.btLightDarkHeader .bt-below-logo-area a.btIconWidget:hover,
.btLightDarkHeader .topBar a.btAccentIconWidget.btIconWidget:hover,
.btLightDarkHeader .topBar a.btIconWidget:hover{color: {$accentColor};}
.btLightAccentHeader .bt-logo-area,
.btLightAccentHeader .bt-vertical-header-top{background-color: {$accentColor};}
.btLightAccentHeader.btMenuHorizontal.btBelowMenu .mainHeader .bt-logo-area{background-color: {$accentColor};}
.btStickyHeaderActive.btMenuHorizontal .mainHeader .bt-logo-area .logo img{height: calc({$logoHeight}px*0.6);
    height: max(50px,calc({$logoHeight}px*0.6));}
.btStickyHeaderActive.btMenuHorizontal .mainHeader .bt-logo-area .btTextLogo{
    line-height: calc({$logoHeight}px*0.6);
    line-height: max(50px,calc({$logoHeight}px*0.6));}
.btStickyHeaderActive.btMenuHorizontal .mainHeader .bt-logo-area .menuPort nav > ul > li > a,
.btStickyHeaderActive.btMenuHorizontal .mainHeader .bt-logo-area .menuPort nav > ul > li > .subToggler{line-height: calc({$logoHeight}px*0.6);
    line-height: max(50px,calc({$logoHeight}px*0.6));}
.btStickyHeaderActive.btMenuHorizontal .mainHeader .bt-logo-area .menuPort nav > ul ul{top: calc({$logoHeight}px*0.6 - ({$logoHeight}px*0.6 - 50px)/2);
    top: max(50px,calc({$logoHeight}px*0.6 - ({$logoHeight}px*0.6 - 50px)/2));}
.btStickyHeaderActive.btMenuHorizontal .mainHeader .bt-logo-area .topBarInMenu{height: calc({$logoHeight}px*0.6);
    height: max(50px,calc({$logoHeight}px*0.6));}
.btStickyHeaderActive.btMenuBelowLogo.btMenuBelowLogoShowArea.btMenuHorizontal .mainHeader .bt-logo-area .topBarInLogoArea{height: calc({$logoHeight}px*0.6);
    height: max(50px,calc({$logoHeight}px*0.6));}
.bt-vertical-menu-trigger .bt_bb_icon{
    background: {$accentColor};}
.btMenuVertical .mainHeader .btCloseVertical:before:hover{color: {$accentColor};}
.btMenuHorizontal .topBarInLogoArea{
    height: {$logoHeight}px;}
.btMenuHorizontal .topBarInLogoArea .topBarInLogoAreaCell{
    border: 0 solid {$accentColor};}
.btLightAccentHeader.btMenuVerticalFullscreenEnabled .mainHeader .menuPort{
    background: {$accentColor} !important;}
.btTransparentLightHeader.btMenuVerticalFullscreenEnabled.btMenuHorizontal .mainHeader .menuPort{
    background: {$alternateColor} !important;}
.btTransparentLightHeader.btMenuVerticalFullscreenEnabled.btMenuHorizontal .mainHeader .menuPort .header_fullscreen_image:before{background: linear-gradient(to right,{$alternateColor} 20%,transparent 100%);}
.btLightAccentHeader.btMenuVerticalFullscreenEnabled.btMenuHorizontal .mainHeader .menuPort .header_fullscreen_image:before{background: linear-gradient(to right,{$accentColor} 20%,transparent 100%);}
.btTransparentLightHeader.btMenuVerticalFullscreenEnabled.btMenuHorizontal .mainHeader .menuPort .header_fullscreen_image:after{background: {$alternateColor};}
.btLightAccentHeader.btMenuVerticalFullscreenEnabled.btMenuHorizontal .mainHeader .menuPort .header_fullscreen_image:after{background: {$accentColor};}
.btTransparentLightHeader.btMenuVerticalFullscreenEnabled.btMenuHorizontal .mainHeader.gutter .header_fullscreen_image:before{background: linear-gradient(to right,{$alternateColor} 40%,transparent 100%);}
.btLightAccentHeader.btMenuVerticalFullscreenEnabled.btMenuHorizontal .mainHeader.gutter .header_fullscreen_image:before{background: linear-gradient(to right,{$accentColor} 40%,transparent 100%);}
.btMenuVerticalFullscreenEnabled.btMenuVertical.btTransparentLightHeader .mainHeader{background: {$alternateColor} !important;}
.btMenuVerticalFullscreenEnabled.btMenuVertical.btTransparentLightHeader .mainHeader .menuPort{
    background: {$alternateColor} !important;}
.btMenuVerticalFullscreenEnabled:not(.btMenuVertical) .mainHeader .menuPort{
    padding: {$logoHeight}px 30px;}
.btStickyHeaderActive.btMenuVerticalFullscreenEnabled:not(.btMenuVertical) .mainHeader .menuPort{top: calc({$logoHeight}px*0.6);
    height: calc(100vh - {$logoHeight}px*0.6);}
.bt-site-footer-copy-menu .port > div .bt-footer-menu .menu li a:after{
    background: {$accentColor};}
.bt-dark-skin .bt-site-footer-copy-menu .port:before,
.btLightSkin .bt-dark-skin .bt-site-footer-copy-menu .port:before,
.bt-dark-skin.btLightSkin .bt-dark-skin .bt-site-footer-copy-menu .port:before{background-color: {$accentColor};}
.bt-content .btArticleHeadline .bt_bb_headline .bt_bb_headline_content a:hover,
.bt-content .btArticleListItem .bt_bb_headline .bt_bb_headline_content a:hover{color: {$accentColor};}
.btPostSingleItemStandard .btArticleShareEtc > div.btReadMoreColumn .bt_bb_button a .bt_bb_icon_holder{background: {$accentColor};}
.btAboutAuthor .aaAvatar:before{
    background: {$accentColor};}
.btAboutAuthor .aaTxt h1 .btArticleAuthor a:before,
.btAboutAuthor .aaTxt h2 .btArticleAuthor a:before,
.btAboutAuthor .aaTxt h3 .btArticleAuthor a:before,
.btAboutAuthor .aaTxt h4 .btArticleAuthor a:before,
.btAboutAuthor .aaTxt h5 .btArticleAuthor a:before,
.btAboutAuthor .aaTxt h6 .btArticleAuthor a:before,
.btAboutAuthor .aaTxt h7 .btArticleAuthor a:before,
.btAboutAuthor .aaTxt h8 .btArticleAuthor a:before,
.btAboutAuthor .aaTxt h1 .btArticleAuthor a:after,
.btAboutAuthor .aaTxt h2 .btArticleAuthor a:after,
.btAboutAuthor .aaTxt h3 .btArticleAuthor a:after,
.btAboutAuthor .aaTxt h4 .btArticleAuthor a:after,
.btAboutAuthor .aaTxt h5 .btArticleAuthor a:after,
.btAboutAuthor .aaTxt h6 .btArticleAuthor a:after,
.btAboutAuthor .aaTxt h7 .btArticleAuthor a:after,
.btAboutAuthor .aaTxt h8 .btArticleAuthor a:after{
    color: {$accentColor};}
.btMediaBox.btQuote:before,
.btMediaBox.btLink:before{
    background-color: {$accentColor};}
.articleSideGutter .asgItem.avatar a:before{
    background: {$accentColor};}
@media (max-width:620px){.btHasAuthorInfo .asgItem.date:before{
    color: {$accentColor};}
}.sticky.btArticleListItem .btArticleHeadline h1 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h2 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h3 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h4 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h5 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h6 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h7 .bt_bb_headline_content span a:after,
.sticky.btArticleListItem .btArticleHeadline h8 .bt_bb_headline_content span a:after{
    color: {$accentColor};}
.post-password-form p:nth-child(2) input[type=\"submit\"]{
    background: {$accentColor};}
.btPagination{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.btPagination .paging p a{
    box-shadow: 0 0 {$accentColor} inset;}
.btPagination .paging p a:hover{box-shadow: 0 -5rem {$accentColor} inset;}
.btPrevNextNav .btPrevNext:before{
    box-shadow: 0 0 {$accentColor} inset;}
.btPrevNextNav .btPrevNext .btPrevNextItem .btPrevNextTitle{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.btPrevNextNav .btPrevNext:hover:before{box-shadow: 0 -5rem {$accentColor} inset;}
.btPrevNextNav .btPrevNext:hover .btPrevNextTitle{color: {$accentColor} !important;}
.bt-link-pages ul .post-page-numbers:after{
    background: {$accentColor};}
.bt-link-pages ul span.post-page-numbers{
    background: {$accentColor};}
.btArticleCategories:before,
.btArticleAuthor:before,
.btArticleDate:before,
.btArticleComments:before{
    color: {$accentColor};}
.btCommentsBox ul.comments li.pingback p a:not(.comment-edit-link),
.btCommentsBox ul.comments li.trackback p a:not(.comment-edit-link),
.bt-comments-box ul.comments li.pingback p a:not(.comment-edit-link),
.bt-comments-box ul.comments li.trackback p a:not(.comment-edit-link){font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.btCommentsBox ul.comments li.pingback p a:not(.comment-edit-link):hover,
.btCommentsBox ul.comments li.trackback p a:not(.comment-edit-link):hover,
.bt-comments-box ul.comments li.pingback p a:not(.comment-edit-link):hover,
.bt-comments-box ul.comments li.trackback p a:not(.comment-edit-link):hover{color: {$accentColor} !important;}
.btCommentsBox ul.comments li.pingback p .edit-link a,
.btCommentsBox ul.comments li.trackback p .edit-link a,
.bt-comments-box ul.comments li.pingback p .edit-link a,
.bt-comments-box ul.comments li.trackback p .edit-link a{
    font-size: .875rem color: {$accentColor};}
.btCommentsBox .vcard h1.author a:hover,
.btCommentsBox .vcard h2.author a:hover,
.btCommentsBox .vcard h3.author a:hover,
.btCommentsBox .vcard h4.author a:hover,
.btCommentsBox .vcard h5.author a:hover,
.btCommentsBox .vcard h6.author a:hover,
.btCommentsBox .vcard h7.author a:hover,
.btCommentsBox .vcard h8.author a:hover,
.bt-comments-box .vcard h1.author a:hover,
.bt-comments-box .vcard h2.author a:hover,
.bt-comments-box .vcard h3.author a:hover,
.bt-comments-box .vcard h4.author a:hover,
.bt-comments-box .vcard h5.author a:hover,
.bt-comments-box .vcard h6.author a:hover,
.bt-comments-box .vcard h7.author a:hover,
.bt-comments-box .vcard h8.author a:hover{color: {$accentColor};}
.btCommentsBox .vcard .posted:before,
.bt-comments-box .vcard .posted:before{
    color: {$accentColor};}
.btCommentsBox .commentTxt .comment p.reply a,
.bt-comments-box .commentTxt .comment p.reply a{
    box-shadow: 0 0 {$accentColor} inset;}
.btCommentsBox .commentTxt .comment p.reply a:hover,
.bt-comments-box .commentTxt .comment p.reply a:hover{box-shadow: 0 -2.5em 0 {$accentColor} inset;}
.btCommentsBox .comment-form .comment-notes a:first-child:hover,
.btCommentsBox .comment-form .logged-in-as a:first-child:hover,
.btCommentsBox + #review_form_wrapper .comment-form .comment-notes a:first-child:hover,
.btCommentsBox + #review_form_wrapper .comment-form .logged-in-as a:first-child:hover,
.bt-comments-box .comment-form .comment-notes a:first-child:hover,
.bt-comments-box .comment-form .logged-in-as a:first-child:hover,
.bt-comments-box + #review_form_wrapper .comment-form .comment-notes a:first-child:hover,
.bt-comments-box + #review_form_wrapper .comment-form .logged-in-as a:first-child:hover{color: {$accentColor} !important;}
.btCommentsBox .comment-form .comment-notes a:last-child,
.btCommentsBox .comment-form .logged-in-as a:last-child,
.btCommentsBox + #review_form_wrapper .comment-form .comment-notes a:last-child,
.btCommentsBox + #review_form_wrapper .comment-form .logged-in-as a:last-child,
.bt-comments-box .comment-form .comment-notes a:last-child,
.bt-comments-box .comment-form .logged-in-as a:last-child,
.bt-comments-box + #review_form_wrapper .comment-form .comment-notes a:last-child,
.bt-comments-box + #review_form_wrapper .comment-form .logged-in-as a:last-child{
    box-shadow: 0 0 {$accentColor} inset;}
.btCommentsBox .comment-form .comment-notes a:last-child:hover,
.btCommentsBox .comment-form .logged-in-as a:last-child:hover,
.btCommentsBox + #review_form_wrapper .comment-form .comment-notes a:last-child:hover,
.btCommentsBox + #review_form_wrapper .comment-form .logged-in-as a:last-child:hover,
.bt-comments-box .comment-form .comment-notes a:last-child:hover,
.bt-comments-box .comment-form .logged-in-as a:last-child:hover,
.bt-comments-box + #review_form_wrapper .comment-form .comment-notes a:last-child:hover,
.bt-comments-box + #review_form_wrapper .comment-form .logged-in-as a:last-child:hover{box-shadow: 0 -2.5em 0 {$accentColor} inset;}
.btCommentsBox .comment-form > .pcItem p.btFieldRequired:after,
.btCommentsBox + #review_form_wrapper .comment-form > .pcItem p.btFieldRequired:after,
.bt-comments-box .comment-form > .pcItem p.btFieldRequired:after,
.bt-comments-box + #review_form_wrapper .comment-form > .pcItem p.btFieldRequired:after{
    background: {$accentColor};}
.btCommentsBox .comment-navigation a:first-child:before,
.bt-comments-box .comment-navigation a:first-child:before{
    box-shadow: 0 0 0 {$accentColor} inset;}
.btCommentsBox .comment-navigation a:last-child:after,
.bt-comments-box .comment-navigation a:last-child:after{
    box-shadow: 0 0 0 {$accentColor} inset;}
.btCommentsBox .comment-navigation a:hover,
.bt-comments-box .comment-navigation a:hover{color: {$accentColor};}
.btCommentsBox .comment-navigation a:hover:first-child:before,
.bt-comments-box .comment-navigation a:hover:first-child:before{
    box-shadow: 0 -3em 0 {$accentColor} inset;}
.btCommentsBox .comment-navigation a:hover:last-child:after,
.bt-comments-box .comment-navigation a:hover:last-child:after{
    box-shadow: 0 -3em 0 {$accentColor} inset;}
.comment-respond .comment-form > .comment-form-author:after,
.comment-respond .comment-form > .comment-form-email:after{
    background: {$accentColor};}
.comment-reply-title small a#cancel-comment-reply-link{
    box-shadow: 0 0 {$accentColor} inset;}
.comment-reply-title small a#cancel-comment-reply-link:hover{box-shadow: 0 -2.5em 0 {$accentColor} inset;}
.btCommentSubmit{
    background: {$accentColor};}
@media (max-width: 520px){.btCommentsBox ul.comments ul.children li.comment article:after,
.bt-comments-box ul.comments ul.children li.comment article:after{
    background: {$accentColor};}
}.no-comments{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.sidebar .widget_bt_bb_recent_comments ul li .posted a:before,
.btSidebar .widget_bt_bb_recent_comments ul li .posted a:before,
.bt-site-footer-widgets .widget_bt_bb_recent_comments ul li .posted a:before{
    color: {$accentColor};}
body:not(.btNoDashInSidebar) .btBox > h4:after,
body:not(.btNoDashInSidebar) .btCustomMenu > h4:after,
body:not(.btNoDashInSidebar) .btTopBox > h4:after{
    background: {$accentColor};}
.btBox ul li a:after,
.btCustomMenu ul li a:after,
.btTopBox ul li a:after{
    background: {$accentColor};}
.btBox ul li.current-menu-item > a,
.btCustomMenu ul li.current-menu-item > a,
.btTopBox ul li.current-menu-item > a{color: {$accentColor};}
.btBox .btImageTextWidget .btImageTextWidgetImage a:before,
.btCustomMenu .btImageTextWidget .btImageTextWidgetImage a:before,
.btTopBox .btImageTextWidget .btImageTextWidgetImage a:before{
    background: {$accentColor};}
.widget_calendar table caption{font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;
    background: {$accentColor};}
.widget_calendar table tbody tr td#today{color: {$accentColor};}
.widget_calendar table tbody td a:after{background: {$accentColor};}
.widget_recent_comments .comment-author-link a:before{
    color: {$accentColor};}
.widget_rss li a.rsswidget{font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.widget_rss li .rss-date:before{
    color: {$accentColor};}
.widget_shopping_cart .widget_shopping_cart_content .mini_cart_item .ppRemove a.remove{
    background-color: {$accentColor};}
.menuPort .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:before,
.topTools .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:before,
.topBarInLogoArea .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:before{
    color: {$accentColor};
    box-shadow: 0 0 {$accentColor} inset;}
.menuPort .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon .bt_bb_icon:hover .bt_bb_icon_holder:before,
.topTools .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon .bt_bb_icon:hover .bt_bb_icon_holder:before,
.topBarInLogoArea .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetIcon .bt_bb_icon:hover .bt_bb_icon_holder:before{box-shadow: 0 -50px {$accentColor} inset;}
.btMenuVertical .menuPort .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetInnerContent .verticalMenuCartToggler:after,
.btMenuVertical .topTools .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetInnerContent .verticalMenuCartToggler:after,
.btMenuVertical .topBarInLogoArea .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetInnerContent .verticalMenuCartToggler:after{
    box-shadow: 0 0 {$accentColor} inset;}
.btMenuVertical .menuPort .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetInnerContent .verticalMenuCartToggler:hover:after,
.btMenuVertical .topTools .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetInnerContent .verticalMenuCartToggler:hover:after,
.btMenuVertical .topBarInLogoArea .widget_shopping_cart .widget_shopping_cart_content .btCartWidgetInnerContent .verticalMenuCartToggler:hover:after{box-shadow: 0 -2.5em {$accentColor} inset;}
.menuPort .widget_shopping_cart .widget_shopping_cart_content.on .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:before,
.topTools .widget_shopping_cart .widget_shopping_cart_content.on .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:before,
.topBarInLogoArea .widget_shopping_cart .widget_shopping_cart_content.on .btCartWidgetIcon .bt_bb_icon .bt_bb_icon_holder:before{box-shadow: 0 -50px {$accentColor} inset;}
.widget_recent_reviews{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.widget_price_filter .price_slider_wrapper .ui-slider .ui-slider-handle{
    background-color: {$accentColor};}
.btBox .tagcloud a:after,
.btTags ul a:after{
    background: {$accentColor};}
.topTools a.btIconWidget:hover,
.topBarInMenu a.btIconWidget:hover{color: {$accentColor};}
.btIconWidget.widget_bt_button_widget .bt_button_widget.bt_button_widget_accent{background: {$accentColor};}
.btIconWidget.widget_bt_button_widget .bt_button_widget.bt_button_widget_alternate{background: {$alternateColor};}
.btAccentIconWidget.btIconWidget .btIconWidgetIcon{color: {$accentColor};}
a.btAccentIconWidget.btIconWidget:hover{color: {$accentColor};}
.bt-site-footer-widgets .btSearch button:after,
.btSidebar .btSearch button:after,
.btSidebar .widget_product_search button:after{
    background: {$accentColor};}
.widget_search .btSearch .bt_bb_icon .bt_bb_icon_holder:before{
    color: {$accentColor};
    box-shadow: 0 0 {$accentColor} inset;}
.widget_search .btSearch .bt_bb_icon .bt_bb_icon_holder:hover:before{box-shadow: 0 -50px {$accentColor} inset;}
.btSearchInner.btFromTopBox .btSearchInnerClose .bt_bb_icon .bt_bb_icon_holder{
    box-shadow: 0 0 {$accentColor} inset !important;}
.btSearchInner.btFromTopBox .btSearchInnerClose .bt_bb_icon .bt_bb_icon_holder:hover{box-shadow: 0 -5em {$accentColor} inset !important;}
.btSearchInner.btFromTopBox form button{
    box-shadow: 0 0 {$accentColor} inset;}
.btSearchInner.btFromTopBox form button:hover{box-shadow: 0 -5em {$accentColor} inset;}
::selection{background: {$accentColor};}
.bt_bb_section[class*=\"accent_solid\"]:before{background: {$accentColor};}
.bt_bb_section[class*=\"alternate_solid\"]:before{background: {$alternateColor};}
.bt_bb_section[class*=\"accent_gradient\"]:before{background: linear-gradient(to bottom,{$accentColor} 0%,transparent 100%);}
.bt_bb_section[class*=\"alternate_gradient\"]:before{background: linear-gradient(to bottom,{$alternateColor} 0%,transparent 100%);}
.bt_bb_separator.bt_bb_color_accent{border-color: {$accentColor};}
.bt_bb_separator.bt_bb_color_alternate{border-color: {$alternateColor};}
.bt_bb_headline .bt_bb_headline_superheadline,
.bt_bb_headline .bt_bb_headline_with_icon_superheadline,
.bt_bb_headline_with_icon .bt_bb_headline_superheadline,
.bt_bb_headline_with_icon .bt_bb_headline_with_icon_superheadline{
    font-family: \"{$headingSuperTitleFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_dash_top_bottom.bt_bb_headline .bt_bb_headline_superheadline:before,
.bt_bb_dash_top.bt_bb_headline .bt_bb_headline_superheadline:before,
.bt_bb_dash_top_bottom.bt_bb_headline .bt_bb_headline_with_icon_superheadline:before,
.bt_bb_dash_top.bt_bb_headline .bt_bb_headline_with_icon_superheadline:before,
.bt_bb_dash_top_bottom.bt_bb_headline_with_icon .bt_bb_headline_superheadline:before,
.bt_bb_dash_top.bt_bb_headline_with_icon .bt_bb_headline_superheadline:before,
.bt_bb_dash_top_bottom.bt_bb_headline_with_icon .bt_bb_headline_with_icon_superheadline:before,
.bt_bb_dash_top.bt_bb_headline_with_icon .bt_bb_headline_with_icon_superheadline:before{
    background: {$accentColor};}
.bt_bb_headline.bt_bb_subheadline .bt_bb_headline_subheadline,
.bt_bb_headline.bt_bb_subheadline .bt_bb_headline_with_icon_subheadline,
.bt_bb_headline_with_icon.bt_bb_subheadline .bt_bb_headline_subheadline,
.bt_bb_headline_with_icon.bt_bb_subheadline .bt_bb_headline_with_icon_subheadline{
    font-family: \"{$headingSubTitleFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_headline .bt_bb_headline_content u:after,
.bt_bb_headline .bt_bb_headline_content s:after,
.bt_bb_headline .bt_bb_headline_with_icon_content u:after,
.bt_bb_headline .bt_bb_headline_with_icon_content s:after,
.bt_bb_headline_with_icon .bt_bb_headline_content u:after,
.bt_bb_headline_with_icon .bt_bb_headline_content s:after,
.bt_bb_headline_with_icon .bt_bb_headline_with_icon_content u:after,
.bt_bb_headline_with_icon .bt_bb_headline_with_icon_content s:after{
    background: {$accentColor};}
.bt_bb_headline .bt_bb_headline_content em u:after,
.bt_bb_headline .bt_bb_headline_content em s:after,
.bt_bb_headline .bt_bb_headline_with_icon_content em u:after,
.bt_bb_headline .bt_bb_headline_with_icon_content em s:after,
.bt_bb_headline_with_icon .bt_bb_headline_content em u:after,
.bt_bb_headline_with_icon .bt_bb_headline_content em s:after,
.bt_bb_headline_with_icon .bt_bb_headline_with_icon_content em u:after,
.bt_bb_headline_with_icon .bt_bb_headline_with_icon_content em s:after{background: {$alternateColor};}
.bt_bb_dash_bottom.bt_bb_headline .bt_bb_headline_content:after,
.bt_bb_dash_top_bottom.bt_bb_headline .bt_bb_headline_content:after,
.bt_bb_dash_bottom.bt_bb_headline_with_icon .bt_bb_headline_content:after,
.bt_bb_dash_top_bottom.bt_bb_headline_with_icon .bt_bb_headline_content:after{
    background: {$accentColor};}
.bt_bb_headline_with_icon .bt_bb_icon_holder{
    background: {$accentColor};}
.bt_bb_button.bt_bb_style_with_huge_icon a .bt_bb_icon_holder:after{
    background: {$accentColor};}
.bt_bb_button.bt_bb_style_underlined a .bt_bb_button_text:after{
    background: {$accentColor};}
.bt_bb_service .bt_bb_service_content .bt_bb_service_content_title{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_service .bt_bb_service_content .bt_bb_service_content_title u:after,
.bt_bb_service .bt_bb_service_content .bt_bb_service_content_title s:after{
    background: {$accentColor};}
.bt_bb_service .bt_bb_service_content .bt_bb_service_content_title em u:after,
.bt_bb_service .bt_bb_service_content .bt_bb_service_content_title em s:after{background: {$alternateColor};}
.bt_bb_service:hover .bt_bb_service_content_title a{color: {$accentColor};}
.bt_bb_progress_bar .bt_bb_progress_bar_inner .bt_bb_progress_bar_percent{font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_progress_bar_advanced .progressbar-text{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_masonry_image_grid .bt_bb_grid_item .bt_bb_grid_item_inner:after{
    background: {$accentColor};}
.bt_bb_post_grid_loader:after{
    background: {$accentColor};}
.bt_bb_content_slider_item[class*=\"accent_solid\"]:before{background: {$accentColor};}
.bt_bb_content_slider_item[class*=\"alternate_solid\"]:before{background: {$alternateColor};}
button.slick-arrow:after{
    background: {$accentColor};}
.bt_bb_thick_line_accent.bt_bb_slider .slick-slider:after{background: {$accentColor};}
.bt_bb_thick_line_alternate.bt_bb_slider .slick-slider:after{background: {$alternateColor};}
.slick-slider .slick-dots li.slick-active:after{
    background: {$accentColor};}
.bt_bb_active_dot_accent .slick-slider .slick-dots li.slick-active:after{background: {$accentColor};}
.bt_bb_active_dot_alternate .slick-slider .slick-dots li.slick-active:after{background: {$alternateColor};}
.bt_bb_custom_menu.bt_bb_direction_horizontal ul ul li a:after{
    background-color: {$accentColor};}
.bt_bb_custom_menu.bt_bb_direction_horizontal > div > ul > li > a:after{
    background: {$accentColor};}
.bt_bb_custom_menu.bt_bb_direction_horizontal > div > ul > li > a:before{
    background: {$accentColor};}
.bt_bb_custom_menu.bt_bb_direction_vertical ul li a:after{
    background: {$accentColor};}
.bt_bb_custom_menu.btBulletedMenu ul li:before{
    background: {$accentColor};}
.btAlternateBullets.bt_bb_custom_menu.btBulletedMenu ul li:before{background: {$alternateColor};}
.bt_bb_style_simple ul.bt_bb_tabs_header li span:after{
    background: {$accentColor};}
.bt_bb_accordion .bt_bb_accordion_item .bt_bb_accordion_item_title{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.bt_bb_style_simple.bt_bb_accordion .bt_bb_accordion_item .bt_bb_accordion_item_title:before{
    background-color: {$accentColor};}
.btCounterHolder{font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
.btCounterHolder .btCountdownHolder span[class$=\"_text\"]{font-family: \"{$bodyFont}\",Arial,Helvetica,sans-serif;}
.btCountDownAccentNumbers.btCounterHolder .btCountdownHolder span[class^=\"n\"],
.btCountDownAccentNumbers.btCounterHolder .btCountdownHolder .days > span:first-child,
.btCountDownAccentNumbers.btCounterHolder .btCountdownHolder .days > span:nth-child(2),
.btCountDownAccentNumbers.btCounterHolder .btCountdownHolder .days > span:nth-child(3){color: {$accentColor};}
div.wpcf7 .ajax-loader:after{
    background: {$accentColor};}
.wpcf7-form .wpcf7-submit{
    background: {$accentColor} !important;}
.wpcf7-form .bt_bb_cf7_alternate_submit .wpcf7-submit{background: {$alternateColor} !important;}
.wpcf7 .bt_bb_cf7_form .bt_bb_cf7_row .bt_bb_cf7_element.bt_bb_cf7_element_required .wpcf7-form-control-wrap:after{
    background: {$accentColor};}
.bt_bb_back_to_top .bt_back_to_top_button{background: {$accentColor};}
.bt_bb_back_to_top_alternate.bt_bb_back_to_top .bt_back_to_top_button{background: {$alternateColor};}
.bt_bb_back_to_top .bt_back_to_top_button_no_icon{
    background: {$accentColor};}
.bt_bb_back_to_top_alternate.bt_bb_back_to_top .bt_back_to_top_button_no_icon{background: {$alternateColor};}
button.mfp-close{
    box-shadow: 0 0 {$accentColor} inset !important;}
button.mfp-close:hover{
    box-shadow: 0 -5rem {$accentColor} inset !important;}
button.mfp-arrow:hover{box-shadow: 0 -5em {$accentColor} inset !important;}
.bt_bb_masonry_post_tiles .bt_bb_post_grid_filter span:after,
.bt_bb_masonry_portfolio_tiles .bt_bb_post_grid_filter span:after{
    background: {$accentColor};}
.bt_bb_masonry_post_tiles .bt_bb_masonry_post_tiles_content .bt_bb_grid_item .bt_bb_grid_item_inner .bt_bb_grid_item_inner_content .arrow,
.bt_bb_masonry_post_tiles .bt_bb_masonry_portfolio_tiles_content .bt_bb_grid_item .bt_bb_grid_item_inner .bt_bb_grid_item_inner_content .arrow,
.bt_bb_masonry_portfolio_tiles .bt_bb_masonry_post_tiles_content .bt_bb_grid_item .bt_bb_grid_item_inner .bt_bb_grid_item_inner_content .arrow,
.bt_bb_masonry_portfolio_tiles .bt_bb_masonry_portfolio_tiles_content .bt_bb_grid_item .bt_bb_grid_item_inner .bt_bb_grid_item_inner_content .arrow{
    box-shadow: 0 0 0 {$accentColor} inset;}
.bt_bb_masonry_post_tiles .bt_bb_masonry_post_tiles_content .bt_bb_grid_item:hover .bt_bb_grid_item_inner .bt_bb_grid_item_inner_content .arrow,
.bt_bb_masonry_post_tiles .bt_bb_masonry_portfolio_tiles_content .bt_bb_grid_item:hover .bt_bb_grid_item_inner .bt_bb_grid_item_inner_content .arrow,
.bt_bb_masonry_portfolio_tiles .bt_bb_masonry_post_tiles_content .bt_bb_grid_item:hover .bt_bb_grid_item_inner .bt_bb_grid_item_inner_content .arrow,
.bt_bb_masonry_portfolio_tiles .bt_bb_masonry_portfolio_tiles_content .bt_bb_grid_item:hover .bt_bb_grid_item_inner .bt_bb_grid_item_inner_content .arrow{box-shadow: 0 -4.063em 0 {$accentColor} inset;}
.bt_bb_portfolio_slider .bt_bb_grid_item .bt_bb_grid_item_inner .bt_bb_grid_item_inner_content .arrow{
    box-shadow: 0 0 0 {$accentColor} inset;}
.bt_bb_portfolio_slider .bt_bb_grid_item:hover .bt_bb_grid_item_inner .bt_bb_grid_item_inner_content .arrow{box-shadow: 0 -4.063em 0 {$accentColor} inset;}
.bt_bb_masonry_post_grid .bt_bb_post_grid_filter span:after,
.bt_bb_masonry_portfolio_grid .bt_bb_post_grid_filter span:after{
    background: {$accentColor};}
.bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category:before,
.bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category:before{
    color: {$accentColor};}
.bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category a:hover,
.bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category a:hover{color: {$accentColor};}
.bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category .post-categories li a:hover,
.bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_category .post-categories li a:hover{color: {$accentColor};}
.bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta .bt_bb_grid_item_item_author:before,
.bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta .bt_bb_grid_item_item_comments:before,
.bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta .bt_bb_grid_item_item_author:before,
.bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta .bt_bb_grid_item_item_comments:before{
    color: {$accentColor};}
.bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta .bt_bb_grid_item_item_author a:hover,
.bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta .bt_bb_grid_item_item_comments a:hover,
.bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta .bt_bb_grid_item_item_author a:hover,
.bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_meta .bt_bb_grid_item_item_comments a:hover{color: {$accentColor};}
.bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_post_title a:hover,
.bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_post_title a:hover{color: {$accentColor};}
.bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_post_title:after,
.bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_post_title:after{background: {$accentColor};}
.bt_bb_masonry_post_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_post_title:before,
.bt_bb_masonry_portfolio_grid .bt_bb_grid_item_post_content .bt_bb_grid_item_post_title:before{
    background: {$accentColor};}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_image a:before{
    background: {$accentColor};}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_content .bt_bb_latest_posts_item_category .post-categories li a:hover{color: {$accentColor};}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_content .bt_bb_latest_posts_item_meta > span:before{
    color: {$accentColor};}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_content .bt_bb_latest_posts_item_meta > span.bt_bb_latest_posts_item_author a:hover{color: {$accentColor};}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_content .bt_bb_latest_posts_item_title a:hover{color: {$accentColor};}
.bt_bb_latest_posts .bt_bb_latest_posts_item .bt_bb_latest_posts_item_content .bt_bb_latest_posts_item_read_more a{
    background: {$accentColor};}
.bt_bb_post_slider .bt_bb_post_slider_item .bt_bb_post_slider_item_image a:before{
    background: {$accentColor};}
.bt_bb_post_slider .bt_bb_post_slider_item .bt_bb_post_slider_item_content .bt_bb_post_slider_item_category .post-categories li a:hover{color: {$accentColor};}
.bt_bb_post_slider .bt_bb_post_slider_item .bt_bb_post_slider_item_content .bt_bb_post_slider_item_meta > span:before{
    color: {$accentColor};}
.bt_bb_post_slider .bt_bb_post_slider_item .bt_bb_post_slider_item_content .bt_bb_post_slider_item_meta > span.bt_bb_post_slider_item_author a:hover{color: {$accentColor};}
.bt_bb_post_slider .bt_bb_post_slider_item .bt_bb_post_slider_item_content .bt_bb_post_slider_item_title a:hover{color: {$accentColor};}
.bt_bb_post_slider .bt_bb_post_slider_item .bt_bb_post_slider_item_content .bt_bb_post_slider_item_read_more a:after{
    background: {$accentColor};}
.btWorkingHours .btWorkingHoursInner .bt_bb_working_hours_inner_row .bt_bb_working_hours_inner_wrapper .bt_bb_working_hours_inner_link a{
    background: {$accentColor};}
@media (min-width: 993px){.bt_bb_border_color_accent.bt_bb_column .bt_bb_column_content,
.bt_bb_border_color_accent.bt_bb_column_inner .bt_bb_column_content_inner{border-color: {$accentColor};}
.bt_bb_border_color_alternate.bt_bb_column .bt_bb_column_content,
.bt_bb_border_color_alternate.bt_bb_column_inner .bt_bb_column_content_inner{border-color: {$alternateColor};}
}.btFooterAccentIcon.bt_bb_icon .bt_bb_icon_holder:before{color: {$accentColor} !important;}
.btFooterAlternateIcon.bt_bb_icon .bt_bb_icon_holder:before{color: {$alternateColor} !important;}
.btAlternateQuoteIcon blockquote:before{color: {$alternateColor};}
.products ul li.product .btWooShopLoopItemInner .bt_bb_headline .bt_bb_headline_content a:hover,
ul.products li.product .btWooShopLoopItemInner .bt_bb_headline .bt_bb_headline_content a:hover{color: {$accentColor};}
.products ul li.product .btWooShopLoopItemInner .bt_bb_headline:before,
ul.products li.product .btWooShopLoopItemInner .bt_bb_headline:before{
    background: {$accentColor};}
.products ul li.product.product-category a h2:before,
ul.products li.product.product-category a h2:before{
    background: {$accentColor};}
.products ul li.product.product-category a:hover h2,
ul.products li.product.product-category a:hover h2{color: {$accentColor};}
nav.woocommerce-pagination ul li span.current:after{background: {$accentColor};}
nav.woocommerce-pagination ul li.woo-first-page a,
nav.woocommerce-pagination ul li.woo-last-page a{
    box-shadow: 0 0 {$accentColor} inset;}
nav.woocommerce-pagination ul li.woo-first-page a:hover,
nav.woocommerce-pagination ul li.woo-last-page a:hover{box-shadow: 0 -5rem {$accentColor} inset;}
div.product div.images .woocommerce-product-gallery__wrapper .woocommerce-product-gallery__image a:after{
    background: {$accentColor};}
div.product div.images .woocommerce-product-gallery__trigger:after{
    box-shadow: 0 0 {$accentColor} inset;}
div.product div.images .woocommerce-product-gallery__trigger:hover:after{box-shadow: 0 -5rem {$accentColor} inset;}
div.product div.summary form.cart .group_table a{font-family: \"{$headingFont}\",Arial,Helvetica;}
div.product div.summary form.cart .group_table a:hover{color: {$accentColor} !important;}
div.product div.summary form.cart .single_add_to_cart_button{background: {$accentColor} !important;}
.reset_variations{
    box-shadow: 0 0 {$accentColor} inset;}
.reset_variations:hover{box-shadow: 0 -2.5em 0 {$accentColor} inset;}
table.shop_table td.product-remove a.remove{
    background-color: {$accentColor};}
table.shop_table td.product-thumbnail a:before{
    background: {$accentColor};}
table.shop_table .product-name{
    font-family: \"{$headingFont}\",Arial,Helvetica,sans-serif;}
table.shop_table .product-name a:hover{color: {$accentColor} !important;}
tr.cart-subtotal,
tfoot{border-top: 2px solid {$accentColor};}
tr.order-total,
tfoot{border-bottom: 2px solid {$accentColor} !important;}
ul.wc_payment_methods li .about_paypal{
    color: {$accentColor};}
.woocommerce-MyAccount-navigation ul li a:after{
    background: {$accentColor};}
form fieldset legend{
    font-family: {$headingFont},Arial,Helvetica,sans-serif;}
form .form-row .required:after{
    background: {$accentColor};}
form .form-row.woocommerce-invalid .select2-container,
form .form-row.woocommerce-invalid input.input-text,
form .form-row.woocommerce-invalid select{border-color: {$accentColor};}
.woocommerce-error:before,
.woocommerce-info:before,
.woocommerce-message:before{
    background: {$accentColor};}
.woocommerce-info a:not(.button),
.woocommerce-message a:not(.button){color: {$accentColor};}
.woocommerce-info a.showcoupon,
.woocommerce-message a.showcoupon{color: {$accentColor};}
.woocommerce-error{box-shadow: 0 0 0 4px {$accentColor} inset;}
.woocommerce .btSidebar a.button,
.woocommerce .bt-content a.button,
.woocommerce-page .btSidebar a.button,
.woocommerce-page .bt-content a.button,
.woocommerce .btSidebar input[type=\"submit\"],
.woocommerce .bt-content input[type=\"submit\"],
.woocommerce-page .btSidebar input[type=\"submit\"],
.woocommerce-page .bt-content input[type=\"submit\"],
.woocommerce .btSidebar :not(.widget_product_search) button[type=\"submit\"],
.woocommerce .bt-content :not(.widget_product_search) button[type=\"submit\"],
.woocommerce-page .btSidebar :not(.widget_product_search) button[type=\"submit\"],
.woocommerce-page .bt-content :not(.widget_product_search) button[type=\"submit\"],
.woocommerce .btSidebar input.button,
.woocommerce .bt-content input.button,
.woocommerce-page .btSidebar input.button,
.woocommerce-page .bt-content input.button,
div.woocommerce a.button,
div.woocommerce input[type=\"submit\"],
div.woocommerce :not(.widget_product_search) button[type=\"submit\"],
div.woocommerce input.button{
    background: {$accentColor};}
.woocommerce .btSidebar a.edit,
.woocommerce .bt-content a.edit,
.woocommerce-page .btSidebar a.edit,
.woocommerce-page .bt-content a.edit,
div.woocommerce a.edit{
    color: {$accentColor};}
.star-rating span:before{
    color: {$accentColor};}
p.stars a[class^=\"star-\"].active:after,
p.stars a[class^=\"star-\"]:hover:after{color: {$accentColor};}
.pswp__top-bar .pswp__button{
    box-shadow: 0 0 {$accentColor} inset !important;}
.pswp__top-bar .pswp__button:hover{
    box-shadow: 0 -5em {$accentColor} inset !important;}
button.pswp__button.pswp__button--arrow--left,
button.pswp__button.pswp__button--arrow--right{
    box-shadow: 0 0 {$accentColor} inset !important;}
button.pswp__button.pswp__button--arrow--left:hover,
button.pswp__button.pswp__button--arrow--right:hover{box-shadow: 0 -5em {$accentColor} inset !important;}
.select2-container .select2-dropdown .select2-results__option:after{
    background: {$accentColor};}
.btQuoteBooking .ddChild ul li:after{
    background: {$accentColor};}
.btQuoteBooking .ui-slider .ui-slider-handle{background: {$accentColor};}
.btQuoteBooking .btQuoteSwitch.on .btQuoteSwitchInner{background: {$accentColor} !important;}
.btQuoteBooking .btTotalNextWrapper .btQuoteTotal{background: {$accentColor};}
.btQuoteBooking .btContactNext{background: {$accentColor};}
.btQuoteBooking .btQuoteContact .btQuoteItem.btContactFieldMandatory:after{
    background: {$accentColor};}
.btQuoteBooking .btQuoteContact .btQuoteItem.btContactFieldMandatory.btContactFieldError input,
.btQuoteBooking .btQuoteContact .btQuoteItem.btContactFieldMandatory.btContactFieldError textarea,
.btQuoteBooking .btQuoteContact .btQuoteItem.btContactFieldMandatory.btContactFieldError .btDropDown .dd.ddcommon.borderRadius .ddTitle .ddTitleText{border-color: {$accentColor};}
.btQuoteBooking .btContactSubmit{
    background: {$accentColor};}
.btDatePicker .ui-datepicker-header{background: {$accentColor};}
.bt_bb_group .bt_bb_group_item .bt_bb_group_item_content .bt_bb_group_item_content_hover .bt_bb_group_item_arrow{
    background: {$accentColor};}
.btCompanyHistory .bold_timeline_item{border-bottom: 4px solid {$accentColor} !important;}
.btCompanyHistory .bold_timeline_item_icon{
    border: 2px solid {$accentColor} !important;
    color: {$accentColor} !important;}
.bold_timeline_container.bold_timeline_container_line_position_left.bold_timeline_container_has_line_style .bold_timeline_container_line{
    border-color: {$accentColor};}
.bold_timeline_container.bold_timeline_container_line_position_left.bold_timeline_container_has_line_style .bold_timeline_item_override_marker_type_inherit.bold_timeline_item .bold_timeline_item_marker{
    border-color: {$accentColor};
    background: {$accentColor};}
.bold_timeline_container.bold_timeline_container_line_position_left.bold_timeline_container_has_line_style .bold_timeline_group_header{
    background: {$alternateColor};}
.bold_timeline_container .bold_timeline_item.btAccent .bold_timeline_item_inner{background: {$accentColor} !important;
    border-color: {$accentColor} !important;}
.bold_timeline_container .bold_timeline_item.btAccent .bold_timeline_item_connection{border-left-color: {$accentColor} !important;}
.bold_timeline_container .bold_timeline_item.btAlternate .bold_timeline_item_inner{background: {$alternateColor} !important;
    border-color: {$alternateColor} !important;}
.bold_timeline_container .bold_timeline_item.btAlternate .bold_timeline_item_connection{border-left-color: {$alternateColor} !important;}
.btCompanyHistorySkewed .bold_timeline_item .bold_timeline_item_icon:after{
    background: {$accentColor};}
p.has-drop-cap:not(:focus):first-letter{
    color: {$accentColor};}
", array() );