<?php
// GENERAL ELEMENTS STYLE
if ( ! function_exists( 'boldthemes_customize_general_elements_style' ) ) {
	function boldthemes_customize_general_elements_style( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[general_elements_style]', array(
			'default'           => BoldThemes_Customize_Default::$data['general_elements_style'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_select'
		));
		$wp_customize->add_control( 'general_elements_style', array(
			'label'     => esc_html__( 'General Elements Style', 'amwerk' ),
			'description'    => esc_html__( 'Select your preferred general elements style - square or rounded. This affects the slider pagination, required field marker and pricelists.', 'amwerk' ),
			'section'   => BoldThemesFramework::$pfx . '_general_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[general_elements_style]',
			'priority'  => 120,
			'type'      => 'select',
			'choices'   => array(
				'square'  	=> esc_html__( 'Square', 'amwerk' ),
				'skewed'  	=> esc_html__( 'Skewed square', 'amwerk' ),
				'rounded'  	=> esc_html__( 'Rounded', 'amwerk' ),
			)
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_general_elements_style' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_general_elements_style' );

// HEADING STYLE
if ( ! function_exists( 'boldthemes_customize_heading_style' ) ) {
	function boldthemes_customize_heading_style( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[heading_style]', array(
			'default'           => BoldThemes_Customize_Default::$data['heading_style'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field'
		));
		$wp_customize->add_control( 'heading_style', array(
			'label'     => esc_html__( 'Heading Style', 'amwerk' ),
			'section'   => BoldThemesFramework::$pfx . '_typography_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[heading_style]',
			'priority'  => 95,
			'type'      => 'select',
			'choices'   => array(
				'default' => esc_html__( 'Default', 'amwerk' ),
				'compact' => esc_html__( 'Compact (small line height + bold)', 'amwerk' )
			)
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_heading_style' );

// BUTTONS FONT
if ( ! function_exists( 'boldthemes_customize_button_font' ) ) {
	function boldthemes_customize_button_font( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[button_font]', array(
			'default'           => urlencode( BoldThemes_Customize_Default::$data['button_font'] ),
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_select'
		));
		$wp_customize->add_control( 'button_font', array(
			'label'     => esc_html__( 'Button Font', 'amwerk' ),
			'section'   => BoldThemesFramework::$pfx . '_typo_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[button_font]',
			'priority'  => 99,
			'type'      => 'select',
			'choices'   => BoldThemesFramework::$customize_fonts
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_button_font' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_button_font' );

// Show logo and logo widgets
if ( ! function_exists( 'boldthemes_customize_show_logo_and_logo_widgets' ) ) {
	function boldthemes_customize_show_logo_and_logo_widgets( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[show_logo_and_logo_widgets]', array(
			'default'           => BoldThemes_Customize_Default::$data['show_logo_and_logo_widgets'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_checkbox'
		));
		$wp_customize->add_control( 'show_logo_and_logo_widgets', array(
			'label'    => esc_html__( 'Expanded sticky header', 'amwerk' ),
			'description'    => esc_html__( 'Enabling this will show logo and logo widgets on a sticky header when selected Menu Type is below logo.', 'amwerk' ),
			'section'  => BoldThemesFramework::$pfx . '_header_footer_section',
			'settings' => BoldThemesFramework::$pfx . '_theme_options[show_logo_and_logo_widgets]',
			'priority' => 61,
			'type'     => 'checkbox'
		));	
	}
}
add_action( 'customize_register', 'boldthemes_customize_show_logo_and_logo_widgets' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_show_logo_and_logo_widgets' );

// CUSTOM 404 IMAGE
if ( ! function_exists( 'boldthemes_customize_image_404' ) ) {
	function boldthemes_customize_image_404( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[image_404]', array(
			'default'           => BoldThemes_Customize_Default::$data['image_404'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_image'
		));
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'image_404', array(
			'label'    => esc_html__( 'Custom Error 404 Page Image', 'amwerk' ),
			'description'    => esc_html__( 'Select the background image for 404 page.', 'amwerk' ),
			'section'  => BoldThemesFramework::$pfx . '_general_section',
			'settings' => BoldThemesFramework::$pfx . '_theme_options[image_404]',
			'priority' => 121,
			'context'  => BoldThemesFramework::$pfx . '_image_404'
		)));
	}
}
add_action( 'customize_register', 'boldthemes_customize_image_404' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_image_404' );

// MENU FONT SIZE
if ( ! function_exists( 'boldthemes_customize_menu_font_size' ) ) {
	function boldthemes_customize_menu_font_size( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[menu_font_size]', array(
			'default'           => BoldThemes_Customize_Default::$data['menu_font_size'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_select'
		));
		$wp_customize->add_control( 'menu_font_size', array(
			'label'     => esc_html__( 'Menu Font Size', 'amwerk' ),
			'description'    => esc_html__( 'Set the font size you wish which will affect only the menu and menu widgets.', 'amwerk' ),
			'section'   => BoldThemesFramework::$pfx . '_typo_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[menu_font_size]',
			'priority'  => 100,
			'type'      => 'select',
			'choices'   => array(
				'14'  	=> esc_html__( '14px', 'amwerk' ),
				'15'  	=> esc_html__( '15px', 'amwerk' ),
				'16'  	=> esc_html__( '16px', 'amwerk' ),
				'17'  	=> esc_html__( '17px', 'amwerk' ),
				'18'  	=> esc_html__( '18px', 'amwerk' ),
			)
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_menu_font_size' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_menu_font_size' );

// BLOG GRID GALLERY 
if ( ! function_exists( 'boldthemes_customize_grid_gallery' ) ) {
	function boldthemes_customize_grid_gallery( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[grid_gallery]', array(
			'default'           => BoldThemes_Customize_Default::$data['grid_gallery'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_checkbox'
		));
		$wp_customize->add_control( 'grid_gallery', array(
			'label'     => esc_html__( 'Grid Gallery', 'amwerk' ),
			'description'    => esc_html__( 'Set default gallery type (grid or carousel) for all single post items pages.', 'amwerk' ),
			'section'   => BoldThemesFramework::$pfx . '_blog_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[grid_gallery]',
			'priority'  => 6,
			'type'     => 'checkbox'
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_grid_gallery' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_grid_gallery' );

// POST DEFAULT IMAGE
if ( ! function_exists( 'boldthemes_customize_post_image_default' ) ) {
	function boldthemes_customize_post_image_default( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[post_image_default]', array(
			'default'           => BoldThemes_Customize_Default::$data['post_image_default'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_image'
		));
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'post_image_default', array(
			'label'    => esc_html__( 'Post Default Image', 'amwerk' ),
			'description'    => esc_html__( 'To make all of the post tiles and grids nice, you can select a default image - which will shown up there even if your post doesn\'t have a featured image selected.', 'amwerk' ),
			'section'  => BoldThemesFramework::$pfx . '_blog_section',
			'settings' => BoldThemesFramework::$pfx . '_theme_options[post_image_default]',
			'priority' => 7,
			'context'  => BoldThemesFramework::$pfx . '_post_image_default'
		)));
	}
}
add_action( 'customize_register', 'boldthemes_customize_post_image_default' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_post_image_default' );

// PORTFOLIO GRID GALLERY 
if ( ! function_exists( 'boldthemes_customize_pf_grid_gallery' ) ) {
	function boldthemes_customize_pf_grid_gallery( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[pf_grid_gallery]', array(
			'default'           => BoldThemes_Customize_Default::$data['pf_grid_gallery'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_checkbox'
		));
		$wp_customize->add_control( 'pf_grid_gallery', array(
			'label'     => esc_html__( 'Grid Gallery', 'amwerk' ),
			'description'    => esc_html__( 'Set default gallery type (grid or carousel)for all single portfolio items pages.', 'amwerk' ),
			'section'   => BoldThemesFramework::$pfx . '_pf_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[pf_grid_gallery]',
			'priority'  => 6,
			'type'     => 'checkbox'
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_pf_grid_gallery' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_pf_grid_gallery' );

// PORTFOLIO DEFAULT IMAGE
if ( ! function_exists( 'boldthemes_customize_pf_slider_image_default' ) ) {
	function boldthemes_customize_pf_slider_image_default( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[pf_slider_image_default]', array(
			'default'           => BoldThemes_Customize_Default::$data['pf_slider_image_default'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_image'
		));
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'pf_slider_image_default', array(
			'label'    => esc_html__( 'Portflio Default Image', 'amwerk' ),
			'description'    => esc_html__( 'To make all of the portfolio tiles and grids nice, you can select a default image - which will shown up there even if your portfolio item doesn\'t have a featured image selected.', 'amwerk' ),
			'section'  => BoldThemesFramework::$pfx . '_pf_section',
			'settings' => BoldThemesFramework::$pfx . '_theme_options[pf_slider_image_default]',
			'priority' => 8,
			'context'  => BoldThemesFramework::$pfx . '_pf_slider_image_default'
		)));
	}
}
add_action( 'customize_register', 'boldthemes_customize_pf_slider_image_default' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_pf_slider_image_default' );

// BACK TO TOP 
if ( ! function_exists( 'boldthemes_customize_back_to_top' ) ) {
	function boldthemes_customize_back_to_top( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[back_to_top]', array(
			'default'           => BoldThemes_Customize_Default::$data['back_to_top'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_checkbox'
		));
		$wp_customize->add_control( 'back_to_top', array(
			'label'     => esc_html__( 'Enable back to top.', 'amwerk' ),
			'description'    => esc_html__( 'Checking this enables the small feature that shows the styled back to top element at the bottom of the page, which appears after some scrolling.', 'amwerk' ),
			'section'   => BoldThemesFramework::$pfx . '_general_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[back_to_top]',
			'priority'  => 110,
			'type'     => 'checkbox'
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_back_to_top' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_back_to_top' );

// BACK TO TOP STYLE
if ( ! function_exists( 'boldthemes_customize_back_to_top_style' ) ) {
	function boldthemes_customize_back_to_top_style( $wp_customize ) {		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[back_to_top_style]', array(
			'default'           => BoldThemes_Customize_Default::$data['back_to_top_style'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_select'
		));
		$wp_customize->add_control( 'back_to_top_style', array(
			'label'     => esc_html__( 'Back to top style.', 'amwerk' ),
			'description'    => esc_html__( 'Style of back to top element at the bottom of the page, which appears after some scrolling.', 'amwerk' ),
			'section'   => BoldThemesFramework::$pfx . '_general_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[back_to_top_style]',
			'priority'  => 111,
			'type'      => 'select',
			'choices'   => array(
				'accent'				=> esc_html__( 'Accent', 'amwerk' ),
				'alternate'   	=> esc_html__( 'Alternate', 'amwerk' )
			)
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_back_to_top_style' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_back_to_top_style' );

// BACK TO TOP TEXT
if ( ! function_exists( 'boldthemes_customize_back_to_top_text' ) ) {
	function boldthemes_customize_back_to_top_text( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[back_to_top_text]', array(
			'default'           => BoldThemes_Customize_Default::$data['back_to_top_text'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field'
		));
		$wp_customize->add_control( 'back_to_top_text', array(
			'label'    => esc_html__( 'Back to Top Text', 'amwerk' ),
			'description'    => esc_html__( 'You can add text to your back to top button, but if you leave it blank you\'ll get only an arrow pointing upwards, which is also nice.', 'amwerk' ),
			'section'  => BoldThemesFramework::$pfx . '_general_section',
			'settings' => BoldThemesFramework::$pfx . '_theme_options[back_to_top_text]',
			'priority' => 112,
			'type'     => 'text'
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_back_to_top_text' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_back_to_top_text' );

// PAGE HEADLINE STYLE
if ( ! function_exists( 'boldthemes_customize_page_headline_style' ) ) {
	function boldthemes_customize_page_headline_style( $wp_customize ) {
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[page_headline_style]', array(
			'default'           => BoldThemes_Customize_Default::$data['page_headline_style'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_select'
		));
		$wp_customize->add_control( 'page_headline_style', array(
			'label'     => esc_html__( 'Page Headline Style', 'amwerk' ),
			'description'    => esc_html__( 'Select page headline style for all the pages on the site.', 'amwerk' ),
			'section'   => BoldThemesFramework::$pfx . '_header_footer_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[page_headline_style]',
			'priority'  => 63,
			'type'      => 'select',
			'choices'   => array(
				'light-dark'  	=> esc_html__( 'Light font, darker background', 'amwerk' ),
				'dark-light'   	=> esc_html__( 'Dark font, lighter background', 'amwerk' ),
				'light-accent'	=> esc_html__( 'Light font, accent background', 'amwerk' ),
				'dark-accent' 	=> esc_html__( 'Dark font, accent background', 'amwerk' ),
				'light-alternate'	=> esc_html__( 'Light font, alternate background', 'amwerk' ),
				'dark-alternate' 	=> esc_html__( 'Dark font, alternate background', 'amwerk' )
			)
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_page_headline_style' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_page_headline_style' );

