<?php

// COLOR SCHEME
if ( is_file( dirname(__FILE__) . '/../../../../plugins/bold-page-builder/content_elements_misc/misc.php' ) ) {
	require_once( dirname(__FILE__) . '/../../../../plugins/bold-page-builder/content_elements_misc/misc.php' );
}
if ( function_exists('bt_bb_get_color_scheme_param_array') ) {
	$color_scheme_arr = bt_bb_get_color_scheme_param_array();
} else {
	$color_scheme_arr = array();
}

// BUTTONS - icon_color_scheme, style

if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_button', 'style' );
}
if ( function_exists( 'bt_bb_add_params' ) ) {
	$color_scheme_arr = bt_bb_get_color_scheme_param_array();
		
	bt_bb_add_params( 'bt_bb_button', array(
		array( 'param_name' => 'style', 'type' => 'dropdown', 'heading' => esc_html__( 'Style', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ),
			'value' => array(
				esc_html__( 'Outline', 'amwerk' ) => 'outline',
				esc_html__( 'Filled', 'amwerk' ) => 'filled',
				esc_html__( 'Clean', 'amwerk' ) => 'clean',
				esc_html__( 'Underlined', 'amwerk' ) => 'underlined',
				esc_html__( 'With Huge Icon', 'amwerk' ) => 'with_huge_icon'
			)
		),
		array( 'param_name' => 'icon_color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon Color Scheme', 'amwerk' ), 'value' => $color_scheme_arr, 'preview' => true, 'group' => esc_html__( 'Design', 'amwerk' ) ),
	));
}

function amwerk_bt_bb_button_class( $class, $atts ) {
	if ( isset( $atts['icon_color_scheme'] ) && $atts['icon_color_scheme'] != '' ) {
		$class[] = 'bt_bb_icon_color_scheme_' . bt_bb_get_color_scheme_id( $atts['icon_color_scheme'] );
	}
	return $class;
}
add_filter( 'bt_bb_button_class', 'amwerk_bt_bb_button_class', 10, 2 );

// COLUMN

if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_column', 'padding' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_column', array(
		array( 'param_name' => 'padding', 'type' => 'dropdown', 'heading' => esc_html__( 'Padding', 'amwerk' ), 'preview' => true,
			'value' => array(
				esc_html__( 'Normal', 'amwerk' ) 		=> 'normal',
				esc_html__( 'Double', 'amwerk' ) 		=> 'double',
				esc_html__( 'Text Indent', 'amwerk' ) 	=> 'text_indent',
				esc_html__( '0px', 'amwerk' ) 			=> '0',
				esc_html__( '5px', 'amwerk' ) 			=> '5',
				esc_html__( '10px', 'amwerk' ) 		=> '10',
				esc_html__( '15px', 'amwerk' ) 		=> '15',
				esc_html__( '20px', 'amwerk' ) 		=> '20',
				esc_html__( '25px', 'amwerk' ) 		=> '25',
				esc_html__( '30px', 'amwerk' ) 		=> '30',
				esc_html__( '35px', 'amwerk' ) 		=> '35',
				esc_html__( '40px', 'amwerk' ) 		=> '40',
				esc_html__( '45px', 'amwerk' ) 		=> '45',
				esc_html__( '50px', 'amwerk' ) 		=> '50',
				esc_html__( '60px', 'amwerk' ) 		=> '60',
				esc_html__( '70px', 'amwerk' ) 		=> '70',
				esc_html__( '80px', 'amwerk' ) 		=> '80',
				esc_html__( '90px', 'amwerk' ) 		=> '90',
				esc_html__( '100px', 'amwerk' ) 		=> '100',
				esc_html__( '110px', 'amwerk' ) 		=> '110',
				esc_html__( '120px', 'amwerk' ) 		=> '120',
				esc_html__( '130px', 'amwerk' ) 		=> '130',
				esc_html__( '140px', 'amwerk' ) 		=> '140',
				esc_html__( '150px', 'amwerk' ) 		=> '150'
			)
		),
		array( 'param_name' => 'top_border', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'amwerk' ) => 'top_border' ), 'group' => esc_html__( 'Design', 'amwerk' ), 'heading' => esc_html__( 'Top Border', 'amwerk' ), 'preview' => true ),
		array( 'param_name' => 'bottom_border', 'type' => 'checkbox', 'group' => esc_html__( 'Design', 'amwerk' ), 'value' => array( esc_html__( 'Yes', 'amwerk' ) => 'bottom_border' ), 'heading' => esc_html__( 'Bottom Border', 'amwerk' ), 'preview' => true ),
		array( 'param_name' => 'left_border', 'type' => 'checkbox', 'group' => esc_html__( 'Design', 'amwerk' ), 'value' => array( esc_html__( 'Yes', 'amwerk' ) => 'left_border' ), 'heading' => esc_html__( 'Left Border', 'amwerk' ), 'preview' => true ),
		array( 'param_name' => 'right_border', 'type' => 'checkbox', 'group' => esc_html__( 'Design', 'amwerk' ), 'value' => array( esc_html__( 'Yes', 'amwerk' ) => 'right_border' ), 'heading' => esc_html__( 'Right Border', 'amwerk' ), 'preview' => true ),
		array( 'param_name' => 'border_color', 'type' => 'dropdown', 'heading' => esc_html__( 'Border color', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ),
			'value' => array(
				esc_html__( 'Black transparent', 'amwerk' ) 		=> '',
				esc_html__( 'White transparent', 'amwerk' ) 		=> 'white_transparent',
				esc_html__( 'Black', 'amwerk' ) 					=> 'black',
				esc_html__( 'White', 'amwerk' ) 					=> 'white',
				esc_html__( 'Accent', 'amwerk' ) 					=> 'accent',
				esc_html__( 'Alternate', 'amwerk' ) 				=> 'alternate'
			)
		),
		array( 'param_name' => 'inner_column_border_radius', 'type' => 'dropdown', 'heading' => esc_html__( 'Border radius', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ),
			'value' => array(
				esc_html__( 'None', 'amwerk' ) 	=> '',
				esc_html__( '5px', 'amwerk' ) 		=> '5',
				esc_html__( '10px', 'amwerk' ) 	=> '10',
				esc_html__( '15px', 'amwerk' ) 	=> '15',
				esc_html__( '20px', 'amwerk' ) 	=> '20',
				esc_html__( '25px', 'amwerk' ) 	=> '25',
				esc_html__( '30px', 'amwerk' ) 	=> '30',
				esc_html__( '35px', 'amwerk' ) 	=> '35',
				esc_html__( '40px', 'amwerk' ) 	=> '40',
				esc_html__( '45px', 'amwerk' ) 	=> '45',
				esc_html__( '50px', 'amwerk' ) 	=> '50'
			)
		),
		array( 'param_name' => 'border_width', 'type' => 'textfield', 'heading' => esc_html__( 'Border width', 'amwerk' ), 'description' => esc_html__( 'Enter value in numbers, it will be calculater as pixels, e.g. 5 will mean 5px. Maximum value is 20.', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ) ),
	));
}

function amwerk_bt_bb_column_class( $class, $atts ) {
	if ( isset( $atts['top_border'] ) && $atts['top_border'] != '' ) {
		$class[] = "bt_bb_top_border";
	}
	if ( isset( $atts['bottom_border'] ) && $atts['bottom_border'] != '' ) {
		$class[] = "bt_bb_bottom_border";
	}
	if ( isset( $atts['left_border'] ) && $atts['left_border'] != '' ) {
		$class[] = "bt_bb_left_border";
	}
	if ( isset( $atts['right_border'] ) && $atts['right_border'] != '' ) {
		$class[] = "bt_bb_right_border";
	}
	if ( isset( $atts['border_color'] ) && $atts['border_color'] != '' ) {
		$class[] = 'bt_bb_border_color' . '_' . $atts['border_color'];
	}
	if ( isset( $atts['border_width'] ) && $atts['border_width'] != '' ) {
		$class[] = 'bt_bb_border_width' . '_' . $atts['border_width'];
	}
	if ( isset( $atts['inner_column_border_radius'] ) && $atts['inner_column_border_radius'] != '' ) {
		$class[] = 'inner_column_border_radius' . '_' . $atts['inner_column_border_radius'];
	}
	return $class;
}
add_filter( 'bt_bb_column_class', 'amwerk_bt_bb_column_class', 10, 2 );

// COLUMN INNER

if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_column_inner', 'padding' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_column_inner', array(
		array( 'param_name' => 'padding', 'type' => 'dropdown', 'heading' => esc_html__( 'Padding', 'amwerk' ), 'preview' => true,
			'value' => array(
				esc_html__( 'Normal', 'amwerk' ) 		=> 'normal',
				esc_html__( 'Double', 'amwerk' ) 		=> 'double',
				esc_html__( 'Text Indent', 'amwerk' ) 	=> 'text_indent',
				esc_html__( '0px', 'amwerk' ) 			=> '0',
				esc_html__( '5px', 'amwerk' ) 			=> '5',
				esc_html__( '10px', 'amwerk' ) 		=> '10',
				esc_html__( '15px', 'amwerk' ) 		=> '15',
				esc_html__( '20px', 'amwerk' ) 		=> '20',
				esc_html__( '25px', 'amwerk' ) 		=> '25',
				esc_html__( '30px', 'amwerk' ) 		=> '30',
				esc_html__( '35px', 'amwerk' ) 		=> '35',
				esc_html__( '40px', 'amwerk' ) 		=> '40',
				esc_html__( '45px', 'amwerk' ) 		=> '45',
				esc_html__( '50px', 'amwerk' ) 		=> '50',
				esc_html__( '60px', 'amwerk' ) 		=> '60',
				esc_html__( '70px', 'amwerk' ) 		=> '70',
				esc_html__( '80px', 'amwerk' ) 		=> '80',
				esc_html__( '90px', 'amwerk' ) 		=> '90',
				esc_html__( '100px', 'amwerk' ) 		=> '100',
				esc_html__( '110px', 'amwerk' ) 		=> '110',
				esc_html__( '120px', 'amwerk' ) 		=> '120',
				esc_html__( '130px', 'amwerk' ) 		=> '130',
				esc_html__( '140px', 'amwerk' ) 		=> '140',
				esc_html__( '150px', 'amwerk' ) 		=> '150'
			)
		),
		array( 'param_name' => 'top_border', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'amwerk' ) => 'top_border' ), 'group' => esc_html__( 'Design', 'amwerk' ), 'heading' => esc_html__( 'Top Border', 'amwerk' ), 'preview' => true ),
		array( 'param_name' => 'bottom_border', 'type' => 'checkbox', 'group' => esc_html__( 'Design', 'amwerk' ), 'value' => array( esc_html__( 'Yes', 'amwerk' ) => 'bottom_border' ), 'heading' => esc_html__( 'Bottom Border', 'amwerk' ), 'preview' => true ),
		array( 'param_name' => 'left_border', 'type' => 'checkbox', 'group' => esc_html__( 'Design', 'amwerk' ), 'value' => array( esc_html__( 'Yes', 'amwerk' ) => 'left_border' ), 'heading' => esc_html__( 'Left Border', 'amwerk' ), 'preview' => true ),
		array( 'param_name' => 'right_border', 'type' => 'checkbox', 'group' => esc_html__( 'Design', 'amwerk' ), 'value' => array( esc_html__( 'Yes', 'amwerk' ) => 'right_border' ), 'heading' => esc_html__( 'Right Border', 'amwerk' ), 'preview' => true ),
		array( 'param_name' => 'border_color', 'type' => 'dropdown', 'heading' => esc_html__( 'Border color', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ),
			'value' => array(
				esc_html__( 'Light', 'amwerk' ) 		=> '',
				esc_html__( 'Dark', 'amwerk' ) 		=> 'dark',
				esc_html__( 'Accent', 'amwerk' ) 		=> 'accent'
			)
		),
		array( 'param_name' => 'border_width', 'type' => 'textfield', 'heading' => esc_html__( 'Border width', 'amwerk' ), 'description' => esc_html__( 'E.g. 5px or 1em', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ) ),
	));
}

function amwerk_bt_bb_column_inner_class( $class, $atts ) {
	if ( isset( $atts['top_border'] ) && $atts['top_border'] != '' ) {
		$class[] = "bt_bb_top_border";
	}
	if ( isset( $atts['bottom_border'] ) && $atts['bottom_border'] != '' ) {
		$class[] = "bt_bb_bottom_border";
	}
	if ( isset( $atts['left_border'] ) && $atts['left_border'] != '' ) {
		$class[] = "bt_bb_left_border";
	}
	if ( isset( $atts['right_border'] ) && $atts['right_border'] != '' ) {
		$class[] = "bt_bb_right_border";
	}
	if ( isset( $atts['border_color'] ) && $atts['border_color'] != '' ) {
		$class[] = 'bt_bb_border_color' . '_' . $atts['border_color'];
	}
	if ( isset( $atts['border_width'] ) && $atts['border_width'] != '' ) {
		$class[] = 'bt_bb_border_width' . '_' . $atts['border_width'];
	}
	return $class;
}
add_filter( 'bt_bb_column_inner_class', 'amwerk_bt_bb_column_inner_class', 10, 2 );


// SERVICE - FONT WIGHT,SHAPE, HEADLINES FONT SIZE 

if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_service', 'shape' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_service', array(		
		array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Shape', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ),
			'value' => array(
				esc_html__( 'Circle', 'amwerk' ) => 'circle',
				esc_html__( 'Square', 'amwerk' ) => 'square',
				esc_html__( 'Rounded Square', 'amwerk' ) => 'round',
				esc_html__( 'Hexagon', 'amwerk' ) => 'hexagon',
				esc_html__( 'Hexagon Rounded', 'amwerk' ) => 'hexagon-rounded'
			)
		),
		array( 'param_name' => 'font_weight', 'type' => 'dropdown', 'heading' => esc_html__( 'Font weight', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ),
			'value' => array(
				esc_html__( 'Default', 'amwerk' ) => '',
				esc_html__( 'Normal', 'amwerk' ) => 'normal',
				esc_html__( 'Bold', 'amwerk' ) => 'bold',
				esc_html__( 'Bolder', 'amwerk' ) => 'bolder',
				esc_html__( 'Lighter', 'amwerk' ) => 'lighter',
				esc_html__( 'Light', 'amwerk' ) => 'light',
				esc_html__( 'Thin', 'amwerk' ) => 'thin',
				esc_html__( 'Font weight 100', 'amwerk' ) => '100',
				esc_html__( 'Font weight 200', 'amwerk' ) => '200',
				esc_html__( 'Font weight 300', 'amwerk' ) => '300',
				esc_html__( 'Font weight 400', 'amwerk' ) => '400',
				esc_html__( 'Font weight 500', 'amwerk' ) => '500',
				esc_html__( 'Font weight 600', 'amwerk' ) => '600',
				esc_html__( 'Font weight 700', 'amwerk' ) => '700',
				esc_html__( 'Font weight 800', 'amwerk' ) => '800',
				esc_html__( 'Font weight 900', 'amwerk' ) => '900',
			)
		),
		array( 'param_name' => 'size_headline', 'type' => 'dropdown', 'heading' => esc_html__( 'Headline Size', 'amwerk' ), 'description' => 'Predefined heading sizes','group' => esc_html__( 'Design', 'amwerk' ),
			'value' => array(
				esc_html__( 'Inherit', 'amwerk' ) => 'inherit',
				esc_html__( 'Extra Small', 'amwerk' ) => 'extrasmall',
				esc_html__( 'Small', 'amwerk' ) => 'small',
				esc_html__( 'Medium', 'amwerk' ) => 'medium',
				esc_html__( 'Normal', 'amwerk' ) => 'normal',
				esc_html__( 'Large', 'amwerk' ) => 'large',
				esc_html__( 'Extra large', 'amwerk' ) => 'extralarge',
				esc_html__( 'Huge', 'amwerk' ) => 'huge'
			)
		),
	));
}

function amwerk_bt_bb_service_class( $class, $atts ) {
	if ( isset( $atts['font_weight'] ) && $atts['font_weight'] != '' ) {
		$class[] = 'bt_bb_font_weight_' . $atts['font_weight'];
	}
	if ( isset( $atts['size_headline'] ) && $atts['size_headline'] != '' ) {
		$class[] = 'bt_bb_size_headline_' . $atts['size_headline'] ;
	}
	return $class;
}
add_filter( 'bt_bb_service_class', 'amwerk_bt_bb_service_class', 10, 2 );

// ICON - edited: shape
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_icon', 'shape' );
}
if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_icon', array(
		array( 'param_name' => 'vertical_position', 'type' => 'dropdown', 'heading' => esc_html__( 'Vertical position', 'amwerk' ),
			'value' => array(
				esc_html__( 'Default', 'amwerk' ) => '',
				esc_html__( 'Half above', 'amwerk' ) => 'half_above',
				esc_html__( 'Full above', 'amwerk' ) => 'full_above'
			)
		),
		array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Shape', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ),
			'value' => array(
				esc_html__( 'Circle', 'amwerk' ) => 'circle',
				esc_html__( 'Square', 'amwerk' ) => 'square',
				esc_html__( 'Rounded Square', 'amwerk' ) => 'round',
				esc_html__( 'Hexagon', 'amwerk' ) => 'hexagon',
				esc_html__( 'Hexagon Rounded', 'amwerk' ) => 'hexagon-rounded'
			)
		),
	));
}

function amwerk_bt_bb_icon_class( $class, $atts ) {
	if ( isset( $atts['vertical_position'] ) && $atts['vertical_position'] != '' ) {
		$class[] = 'bt_bb_vertical_position' . '_' . $atts['vertical_position'];
	}
	return $class;
}
add_filter( 'bt_bb_icon_class', 'amwerk_bt_bb_icon_class', 10, 2 );

// HEADLINE 

/*if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_headline', 'font_weight' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_headline', array(		
		array( 'param_name' => 'font_weight', 'type' => 'dropdown', 'heading' => esc_html__( 'Font weight', 'amwerk' ), 'group' => esc_html__( 'Font', 'amwerk' ),
			'value' => array(
				esc_html__( 'Default', 'amwerk' ) => '',
				esc_html__( 'Normal', 'amwerk' ) => 'normal',
				esc_html__( 'Bold', 'amwerk' ) => 'bold',
				esc_html__( 'Bolder', 'amwerk' ) => 'bolder',
				esc_html__( 'Lighter', 'amwerk' ) => 'lighter',
				esc_html__( 'Light', 'amwerk' ) => 'light',
				esc_html__( 'Thin', 'amwerk' ) => 'thin',
				esc_html__( 'Font weight 100', 'amwerk' ) => '100',
				esc_html__( 'Font weight 200', 'amwerk' ) => '200',
				esc_html__( 'Font weight 300', 'amwerk' ) => '300',
				esc_html__( 'Font weight 400', 'amwerk' ) => '400',
				esc_html__( 'Font weight 500', 'amwerk' ) => '500',
				esc_html__( 'Font weight 600', 'amwerk' ) => '600',
				esc_html__( 'Font weight 700', 'amwerk' ) => '700',
				esc_html__( 'Font weight 800', 'amwerk' ) => '800',
				esc_html__( 'Font weight 900', 'amwerk' ) => '900',
			)
		),
	));
}*/

// CONTENT SLIDER - new: overflow, active_dot_color, inactive_dot_color, slider_arrows_default_state_style

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_content_slider', array(	
		array( 'param_name' => 'overflow', 'type' => 'dropdown', 'heading' => esc_html__( 'Overflow elements', 'amwerk' ), 
			'value' => array(
				esc_html__( 'No', 'amwerk' ) => 'no',
				esc_html__( 'Yes', 'amwerk' ) => 'yes'
			)
		),
		array( 'param_name' => 'active_dot_color', 'type' => 'dropdown', 'heading' => esc_html__( 'Active dot color', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ),
			'value' => array(
				esc_html__( 'Accent', 'amwerk' ) => 'accent',
				esc_html__( 'Alternate', 'amwerk' ) => 'alternate'
			)
		),
		array( 'param_name' => 'inactive_dot_color', 'type' => 'dropdown', 'heading' => esc_html__( 'Inactive dot color', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ),
			'value' => array(
				esc_html__( 'Light font', 'amwerk' ) => 'light_font',
				esc_html__( 'Dark font', 'amwerk' ) => 'dark_font',
				esc_html__( 'Transparent light font', 'amwerk' ) => 'transparent_light_font',
				esc_html__( 'Transparent dark font', 'amwerk' ) => 'transparent_dark_font'
			)
		),
		array( 'param_name' => 'slider_arrows_default_state_style', 'type' => 'dropdown', 'heading' => esc_html__( 'Slider arrows default state style', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ),
			'value' => array(
				esc_html__( 'Dark font on light background', 'amwerk' ) => 'dark_font_light_bg',
				esc_html__( 'Light font on dark background', 'amwerk' ) => 'light_font_dark_bg',
				esc_html__( 'Dark font on transparent background', 'amwerk' ) => 'dark_font_transparent_bg',
				esc_html__( 'Light font on transparent background', 'amwerk' ) => 'light_font_transparent_bg'
			)
		),
	));
}

function amwerk_bt_bb_content_slider_class( $class, $atts ) {
	if ( isset( $atts['overflow'] ) && $atts['overflow'] != '' ) {
		$class[] = 'bt_bb_overflow_' . $atts['overflow'];
	}
	if ( isset( $atts['active_dot_color'] ) && $atts['active_dot_color'] != '' ) {
		$class[] = 'bt_bb_active_dot' . '_' . $atts['active_dot_color'];
	}
	if ( isset( $atts['inactive_dot_color'] ) && $atts['inactive_dot_color'] != '' ) {
		$class[] = 'bt_bb_inactive_dot' . '_' . $atts['inactive_dot_color'];
	}
	if ( isset( $atts['slider_arrows_default_state_style'] ) && $atts['slider_arrows_default_state_style'] != '' ) {
		$class[] = 'bt_bb_slider_arrows' . '_' . $atts['slider_arrows_default_state_style'];
	}	
	
	return $class;
}
add_filter( 'bt_bb_content_slider_class', 'amwerk_bt_bb_content_slider_class', 10, 2 );

// CONTENT SLIDER ITEM - new: overlay
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_content_slider_item', 'background_overlay' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_content_slider_item', array(
		array( 'param_name' => 'background_overlay', 'type' => 'dropdown', 'heading' => esc_html__( 'Background overlay', 'amwerk' ), 
			'value' => array(
				esc_html__( 'No overlay', 'amwerk' )    => '',
				esc_html__( 'Light stripes', 'amwerk' ) => 'light_stripes',
				esc_html__( 'Dark stripes', 'amwerk' )  => 'dark_stripes',
				esc_html__( 'Light solid', 'amwerk' )	  => 'light_solid',
				esc_html__( 'Dark solid', 'amwerk' )	  => 'dark_solid',
				esc_html__( 'Accent solid', 'amwerk' )	  => 'accent_solid',
				esc_html__( 'Alternate solid', 'amwerk' )	  => 'alternate_solid',
				esc_html__( 'Light gradient', 'amwerk' )	  => 'light_gradient',
				esc_html__( 'Dark gradient', 'amwerk' )	  => 'dark_gradient',
				esc_html__( 'Accent gradient', 'amwerk' )	  => 'accent_gradient',
				esc_html__( 'Alternate gradient', 'amwerk' )	  => 'alternate_gradient'
			)
		)
	));
}


// IMAGE SLIDER - new: overflow, bottom line

if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_slider', 'show_arrows' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_slider', array(		
		array( 'param_name' => 'overflow', 'type' => 'dropdown', 'heading' => esc_html__( 'Overflow elements', 'amwerk' ), 
			'value' => array(
				esc_html__( 'No', 'amwerk' ) => 'no',
				esc_html__( 'Yes', 'amwerk' ) => 'yes'
			)
		),
		array( 'param_name' => 'bottom_line', 'type' => 'dropdown', 'heading' => esc_html__( 'Show bottom thick line, with size of the arrows', 'amwerk' ), 
			'value' => array(
				esc_html__( 'No', 'amwerk' ) => 'no',
				esc_html__( 'Yes, accent color', 'amwerk' ) => 'accent',
				esc_html__( 'Yes, alternate color', 'amwerk' ) => 'alternate',
				esc_html__( 'Yes, dark color', 'amwerk' ) => 'dark',
				esc_html__( 'Yes, light color', 'amwerk' ) => 'light'
			)
		),
		array( 'param_name' => 'active_dot_color', 'type' => 'dropdown', 'heading' => esc_html__( 'Active dot color', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ),
			'value' => array(
				esc_html__( 'Accent', 'amwerk' ) => 'accent',
				esc_html__( 'Alternate', 'amwerk' ) => 'alternate'
			)
		),
		array( 'param_name' => 'inactive_dot_color', 'type' => 'dropdown', 'heading' => esc_html__( 'Inactive dot color', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ),
			'value' => array(
				esc_html__( 'Light font', 'amwerk' ) => 'light_font',
				esc_html__( 'Dark font', 'amwerk' ) => 'dark_font',
				esc_html__( 'Transparent light font', 'amwerk' ) => 'transparent_light_font',
				esc_html__( 'Transparent dark font', 'amwerk' ) => 'transparent_dark_font'
			)
		),
		array( 'param_name' => 'slider_arrows_default_state_style', 'type' => 'dropdown', 'heading' => esc_html__( 'Slider arrows default state style', 'amwerk' ), 'group' => esc_html__( 'Design', 'amwerk' ),
			'value' => array(
				esc_html__( 'Dark font on light background', 'amwerk' ) => 'dark_font_light_bg',
				esc_html__( 'Light font on dark background', 'amwerk' ) => 'light_font_dark_bg',
				esc_html__( 'Dark font on transparent background', 'amwerk' ) => 'dark_font_transparent_bg',
				esc_html__( 'Light font on transparent background', 'amwerk' ) => 'light_font_transparent_bg'
			)
		),
		array( 'param_name' => 'show_arrows', 'default' => 'show', 'type' => 'dropdown', 'heading' => esc_html__( 'Navigation arrows', 'amwerk' ),
			'value' => array(
				esc_html__( 'Small', 'amwerk' ) => 'small',
				esc_html__( 'Normal', 'amwerk' ) => 'normal',
				esc_html__( 'Large', 'amwerk' ) => 'large',
				esc_html__( 'Hide', 'amwerk' ) => 'hide'
			)
		),
	));
}

function amwerk_bt_bb_slider_class( $class, $atts ) {
	if ( isset( $atts['overflow'] ) && $atts['overflow'] != '' ) {
		$class[] = 'bt_bb_overflow_' . $atts['overflow'];
	}
	if ( isset( $atts['bottom_line'] ) && $atts['bottom_line'] != '' ) {
		$class[] = 'bt_bb_thick_line_' . $atts['bottom_line'];
	}
	if ( isset( $atts['active_dot_color'] ) && $atts['active_dot_color'] != '' ) {
		$class[] = 'bt_bb_active_dot' . '_' . $atts['active_dot_color'];
	}
	if ( isset( $atts['inactive_dot_color'] ) && $atts['inactive_dot_color'] != '' ) {
		$class[] = 'bt_bb_inactive_dot' . '_' . $atts['inactive_dot_color'];
	}
	if ( isset( $atts['slider_arrows_default_state_style'] ) && $atts['slider_arrows_default_state_style'] != '' ) {
		$class[] = 'bt_bb_slider_arrows' . '_' . $atts['slider_arrows_default_state_style'];
	}	
	if ( isset( $atts['show_arrows'] ) && $atts['show_arrows'] != '' ) {
		$class[] = 'bt_bb_arrows_size' . '_' . $atts['show_arrows'];
	}	
	
	return $class;
}
add_filter( 'bt_bb_slider_class', 'amwerk_bt_bb_slider_class', 10, 2 );

// SEPARATOR - SPACING

if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_separator', 'top_spacing' );
}
if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_separator', 'bottom_spacing' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_separator', array(
		array( 'param_name' => 'top_spacing', 'type' => 'dropdown', 'heading' => esc_html__( 'Top spacing', 'amwerk' ), 'weight' => 0, 'preview' => true,
			'value' => array(
				esc_html__( 'No spacing', 'amwerk' ) 	=> '',
				esc_html__( 'Extra small', 'amwerk' ) 	=> 'extra_small',
				esc_html__( 'Small', 'amwerk' ) 		=> 'small',		
				esc_html__( 'Normal', 'amwerk' ) 		=> 'normal',
				esc_html__( 'Medium', 'amwerk' )	 	=> 'medium',
				esc_html__( 'Large', 'amwerk' ) 		=> 'large',
				esc_html__( 'Extra large', 'amwerk' ) 	=> 'extra_large',
				esc_html__( '5px', 'amwerk' ) 			=> '5',
				esc_html__( '10px', 'amwerk' ) 		=> '10',
				esc_html__( '15px', 'amwerk' ) 		=> '15',
				esc_html__( '20px', 'amwerk' ) 		=> '20',
				esc_html__( '25px', 'amwerk' ) 		=> '25',
				esc_html__( '30px', 'amwerk' ) 		=> '30',
				esc_html__( '35px', 'amwerk' ) 		=> '35',
				esc_html__( '40px', 'amwerk' ) 		=> '40',
				esc_html__( '45px', 'amwerk' ) 		=> '45',
				esc_html__( '50px', 'amwerk' ) 		=> '50',
				esc_html__( '60px', 'amwerk' )			=> '60',
				esc_html__( '70px', 'amwerk' ) 		=> '70',
				esc_html__( '80px', 'amwerk' ) 		=> '80',
				esc_html__( '90px', 'amwerk' ) 		=> '90',
				esc_html__( '100px', 'amwerk' ) 		=> '100',
				esc_html__( '110px', 'amwerk' ) 		=> '110',
				esc_html__( '120px', 'amwerk' ) 		=> '120',
				esc_html__( '130px', 'amwerk' ) 		=> '130',
				esc_html__( '140px', 'amwerk' ) 		=> '140',
				esc_html__( '150px', 'amwerk' ) 		=> '150'
			)
		),
		array( 'param_name' => 'bottom_spacing', 'type' => 'dropdown', 'heading' => esc_html__( 'Bottom spacing', 'amwerk' ), 'weight' => 1, 'preview' => true,
			'value' => array(
				esc_html__( 'No spacing', 'amwerk' ) 		=> '',
				esc_html__( 'Extra small', 'amwerk' ) 		=> 'extra_small',
				esc_html__( 'Small', 'amwerk' ) 			=> 'small',		
				esc_html__( 'Normal', 'amwerk' ) 			=> 'normal',
				esc_html__( 'Medium', 'amwerk' ) 			=> 'medium',
				esc_html__( 'Large', 'amwerk' ) 			=> 'large',
				esc_html__( 'Extra large', 'amwerk' ) 		=> 'extra_large',
				esc_html__( '5px', 'amwerk' ) 				=> '5',
				esc_html__( '10px', 'amwerk' ) 			=> '10',
				esc_html__( '15px', 'amwerk' ) 			=> '15',
				esc_html__( '20px', 'amwerk' ) 			=> '20',
				esc_html__( '25px', 'amwerk' ) 			=> '25',
				esc_html__( '30px', 'amwerk' ) 			=> '30',
				esc_html__( '35px', 'amwerk' ) 			=> '35',
				esc_html__( '40px', 'amwerk' ) 			=> '40',
				esc_html__( '45px', 'amwerk' ) 			=> '45',
				esc_html__( '50px', 'amwerk' ) 			=> '50',
				esc_html__( '60px', 'amwerk' ) 			=> '60',
				esc_html__( '70px', 'amwerk' ) 			=> '70',
				esc_html__( '80px', 'amwerk' ) 			=> '80',
				esc_html__( '90px', 'amwerk' ) 			=> '90',
				esc_html__( '100px', 'amwerk' ) 			=> '100',
				esc_html__( '110px', 'amwerk' ) 			=> '110',
				esc_html__( '120px', 'amwerk' ) 			=> '120',
				esc_html__( '130px', 'amwerk' ) 			=> '130',
				esc_html__( '140px', 'amwerk' ) 			=> '140',
				esc_html__( '150px', 'amwerk' ) 			=> '150'
			)
		),
		array( 'param_name' => 'color', 'type' => 'dropdown', 'heading' => esc_html__( 'Border color', 'amwerk' ), 'preview' => true,
			'value' => array(
				esc_html__( 'Default', 'amwerk' ) 			=> '',
				esc_html__( 'Dark transparent color', 'amwerk' ) 		=> 'dark_transparent',
				esc_html__( 'Light transparent color', 'amwerk' ) 		=> 'light_transparent',
				esc_html__( 'Dark color', 'amwerk' ) 		=> 'dark',
				esc_html__( 'Light color', 'amwerk' ) 		=> 'light',
				esc_html__( 'Accent color', 'amwerk' ) 	=> 'accent',
				esc_html__( 'Alternate color', 'amwerk' ) 	=> 'alternate',
				esc_html__( 'Gray color', 'amwerk' ) 		=> 'gray'
			)
		),
	));
}

function amwerk_bt_bb_separator_class( $class, $atts ) {
	if ( isset( $atts['color'] ) && $atts['color'] != '' ) {
		$class[] = 'bt_bb_color' . '_' . $atts['color'];
	}
	return $class;
}
add_filter( 'bt_bb_separator_class', 'amwerk_bt_bb_separator_class', 10, 2 );

