<?php

if ( ! class_exists( 'BoldThemes_Customize_Default' ) ) {
  
	class BoldThemes_Customize_Default {

		public static $data = array(
		
			// GENERAL SETTINGS
			
			'logo'                      => '',
			'alt_logo'                  => '',
			'accent_color'              => '',
			'alternate_color'           => '',
			'page_background'           => '',
			'page_width'                => 'no_change',
			'hide_headline'             => false,
			'supertitle_position'     	=> true,
			'template_skin'             => 'light',
			'sidebar'                   => 'right',
			'sidebar_use_dash'          => true,
			'disable_preloader'         => true,
			'preloader_text'            => '',
			'autoplay_interval'         => '',
			'custom_js'                 => '',
			'back_to_top_style'			=> 'accent',
			
			// HEADER AND FOOTER
			
			'logo_height'               => '',
			'menu_type'                 => 'horizontal-left',
			'boxed_menu'                => false,
			'header_style'				=> 'transparent-dark',
			'below_menu'                => false,
			'sticky_header'             => true,
			'hide_menu'                 => false,
			'footer_dark_skin'          => false,
			'custom_text'               => '',
			'footer_page_slug'          => '',
			'menu_background'           => '',	
			'menu_background_opacity'   => '',	
			
			
			// TYPOGRAPHY
			
			'body_font'                 => 'no_change',
			'heading_font'              => 'no_change',
			'heading_supertitle_font'   => 'no_change',
			'heading_subtitle_font'     => 'no_change',
			'menu_font'                 => 'no_change',
			'buttons_shape' 			=> 'square',
			
			// BLOG
			
			'blog_grid_gallery_columns' => '3',
			'blog_grid_gallery_gap'     => 'small',
			'blog_list_view'            => 'standard',
			'blog_single_view'          => 'standard',
			'blog_author'               => true,
			'blog_date'                 => true,
			'blog_side_info'            => false,
			'blog_author_info'          => true,
		    'blog_share_facebook'       => true,
		    'blog_share_twitter'        => true,
		    'blog_share_google_plus'    => true,
		    'blog_share_linkedin'       => true,
		    'blog_share_vk'             => true,
		    'blog_share_whatsapp'       => true,
		    'blog_use_dash'             => true,
		    'blog_settings_page_slug'   => '',
			
			// PORTFOLIO
			
			'pf_grid_gallery_columns'   => '3',
			'pf_grid_gallery_gap'       => 'small',
			'pf_list_view'            	=> 'standard',
			'pf_single_view'            => 'columns',
			'pf_share_facebook'         => true,
			'pf_share_twitter'          => true,
			'pf_share_google_plus'      => true,
			'pf_share_linkedin'         => true,
			'pf_share_vk'               => true,
			'pf_share_whatsapp'          => true,
			'pf_use_dash'               => true,
			'pf_settings_page_slug'     => '',
			'pf_slug'     				=> '',
			'pf_category_slug'     		=> '',

			// SHOP
			
			'shop_share_facebook'       => true,
			'shop_share_twitter'        => true,
			'shop_share_google_plus'    => true,
			'shop_share_linkedin'       => true,
			'shop_share_vk'             => true,
			'shop_share_whatsapp'        => true,
			'shop_use_dash'             => true,
			'shop_settings_page_slug'  => ''	
		
		);
	}
}

/**
 * Returns custom header class
 *
 * @return string
 */
if ( ! function_exists( 'boldthemes_get_body_class' ) ) {
	function boldthemes_get_body_class( $extra_class ) {
		
		if ( boldthemes_get_option( 'alt_logo' ) ) {
			$extra_class[] = 'btHasAltLogo';
		}
		
		if ( boldthemes_get_option( 'menu_font_size' ) ) {
			$menu_font_size = boldthemes_get_option( 'menu_font_size' );
			$extra_class[]  = 'btMenuFontSize-' . $menu_font_size;
		}		
		
		if ( boldthemes_get_option( 'general_elements_style' ) ) {
			$general_elements_style = boldthemes_get_option( 'general_elements_style' );
			$extra_class[] = 'btGeneralElementsStyle_' . $general_elements_style;
		}
		
        $show_logo_and_logo_widgets = false;
		$menu_type = boldthemes_get_option( 'menu_type' );
		if ( $menu_type == 'horizontal-center' ) {
			$extra_class[] = 'btMenuCenterEnabled'; 
		} else if ( $menu_type == 'horizontal-left' ) {
			$extra_class[] = 'btMenuLeftEnabled';
		}  else if ( $menu_type == 'horizontal-right' ) {
			$extra_class[] = 'btMenuRightEnabled';
		} else if ( $menu_type == 'horizontal-below-left' ) {
			$extra_class[] = 'btMenuLeftEnabled';
			$extra_class[] = 'btMenuBelowLogo';
            $show_logo_and_logo_widgets = true;
		} else if ( $menu_type == 'horizontal-below-center' ) {
			$extra_class[] = 'btMenuCenterBelowEnabled';
			$extra_class[] = 'btMenuBelowLogo';
            $show_logo_and_logo_widgets = true;
		} else if ( $menu_type == 'horizontal-below-right' ) {
			$extra_class[] = 'btMenuRightEnabled';
			$extra_class[] = 'btMenuBelowLogo';
            $show_logo_and_logo_widgets = true;
		} else if ( $menu_type == 'vertical-left' ) {
			$extra_class[] = 'btMenuVerticalLeftEnabled';
		} else if ( $menu_type == 'vertical-right' ) {
			$extra_class[] = 'btMenuVerticalRightEnabled';
		} else if ( $menu_type == 'vertical-fullscreen' ) {
			$extra_class[] = 'btMenuVerticalFullscreenEnabled';
		} else {
			$extra_class[] = 'btMenuRightEnabled';
		}

		if ( boldthemes_get_option( 'sticky_header' ) ) {
			$extra_class[] = 'btStickyEnabled';
		}

		if ( boldthemes_get_option( 'hide_menu' ) ) {
			$extra_class[] = 'btHideMenu';
		}

		if ( boldthemes_get_option( 'hide_headline' ) || boldthemes_get_option( 'hide_headline' ) == 'hide' ) {
			$extra_class[] = 'btHideHeadline';
		}

		$template_skin = boldthemes_get_option( 'template_skin' );
		if ( $template_skin == '' ) $template_skin = 'light';
		if ( $template_skin != '' ) {
			if ( $template_skin == 'dark' ) {
				$extra_class[] = 'bt-dark-skin';
			} else {
				$extra_class[] = 'bt' . boldthemes_convert_param_to_camel_case( $template_skin ) . 'Skin';
			}
		}

		if ( boldthemes_get_option( 'below_menu' ) ) {
			$extra_class[] = 'btBelowMenu';
		}

		if ( ! boldthemes_get_option( 'sidebar_use_dash' ) ) {
			$extra_class[] = 'btNoDashInSidebar';
		}

		if ( boldthemes_get_option( 'disable_preloader' ) ) {
			$extra_class[] = 'noBodyPreloader';
		} else {
			$extra_class[] = 'bodyPreloader'; 
		}
		
		$buttons_shape = boldthemes_get_option( 'buttons_shape' );
		if ( $buttons_shape != '' ) {
			$extra_class[] = 'bt' . boldthemes_convert_param_to_camel_case( $buttons_shape ) . 'Buttons';
		}
		
		$header_style = boldthemes_get_option( 'header_style' );
		if ( $header_style != '' ) {
			$extra_class[] =  'bt' . boldthemes_convert_param_to_camel_case( $header_style ) . 'Header';
		} else {
			$extra_class[] =  'btTransparentDarkHeader';
		}
		
		if ( boldthemes_get_option( 'page_width' ) == 'boxed' ) {
			$extra_class[] = 'btBoxedPage';
		}

		BoldThemesFramework::$sidebar = '';
		BoldThemesFramework::$sidebar = boldthemes_get_option( 'sidebar' );		
		
		global $wp_registered_sidebars;
		$widget_areas = array_keys( $wp_registered_sidebars );
		
		if ( ! ( ( BoldThemesFramework::$sidebar == 'left' || BoldThemesFramework::$sidebar == 'right' ) && ! is_404() )
			|| 
			( function_exists( 'is_woocommerce' ) && is_woocommerce() && in_array( 'bt_shop_sidebar', $widget_areas ) && ! is_active_sidebar( 'bt_shop_sidebar' ) )
			||
			! is_active_sidebar( 'primary_widget_area' )
			) {
			BoldThemesFramework::$has_sidebar = false;
			$extra_class[] = 'btNoSidebar';
		} else {
			BoldThemesFramework::$has_sidebar = true;
			if ( BoldThemesFramework::$sidebar == 'left' ) {
				$extra_class[] = 'btWithSidebar btSidebarLeft';
			} else {
				$extra_class[] = 'btWithSidebar btSidebarRight';
			}
		}
		
		$animations = boldthemes_rwmb_meta( BoldThemesFramework::$pfx . '_animations' );
		if ( $animations == 'half_page' ) {
			$extra_class[] = 'btHalfPage';
		}
                
        if ( boldthemes_get_option( 'sticky_header' ) && $show_logo_and_logo_widgets && boldthemes_get_option( 'show_logo_and_logo_widgets' ) ) {
			$extra_class[] = 'btMenuBelowLogoShowArea';
		}
		
		$sidebar_vertical_position = boldthemes_get_option( 'sidebar_vertical_position' );
		if ( $sidebar_vertical_position ) {
			$extra_class[] = 'btSidebar'. boldthemes_convert_param_to_camel_case( $sidebar_vertical_position );
		}
		
		$sidebar_style = boldthemes_get_option( 'sidebar_style' );
		if ( $sidebar_style ) {
			$extra_class[] = 'btSidebar'. boldthemes_convert_param_to_camel_case( $sidebar_style );
		}
		
		$page_headline_style = boldthemes_get_option( 'page_headline_style' );
		if ( $page_headline_style != '' ) {
			$extra_class[] =  'btPageHeadline' . boldthemes_convert_param_to_camel_case( $page_headline_style );
		} else {
			$extra_class[] =  'btPageHeadlineTransparentDark';
		}
		
		$extra_class = apply_filters( 'boldthemes_extra_class', $extra_class );
		
		return $extra_class;
	}
}

require_once( get_template_directory() . '/php/before_framework/functions.php' );
require_once( get_template_directory() . '/php/before_framework/customize_params.php' );