<?php
// MENU TYPE
if ( ! function_exists( 'boldthemes_customize_menu_type' ) ) {
	function boldthemes_customize_menu_type( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[menu_type]', array(
			'default'           => BoldThemes_Customize_Default::$data['menu_type'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_select'
		));
		$wp_customize->add_control( 'menu_type', array(
			'label'     => esc_html__( 'Menu Type', 'amwerk' ),
			'description'    => esc_html__( 'Set the menu layout for all the pages on the site. Menu can be horizontal, in line with logo or below logo, or vertical on left or right, or fullscreen vertical hidden by default.', 'amwerk' ),
			'section'   => BoldThemesFramework::$pfx . '_header_footer_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[menu_type]',
			'priority'  => 60,
			'type'      => 'select',
			'choices'   => array(
				'horizontal-left'       => esc_html__( 'Horizontal Left', 'amwerk' ),
				'horizontal-center'     => esc_html__( 'Horizontal Centered', 'amwerk' ),
				'horizontal-right'      => esc_html__( 'Horizontal Right', 'amwerk' ),
				'horizontal-below-left'  => esc_html__( 'Horizontal Left Below Logo', 'amwerk' ),
				'horizontal-below-center'  => esc_html__( 'Horizontal Center Below Logo', 'amwerk' ),
				'horizontal-below-right' => esc_html__( 'Horizontal Right Below Logo', 'amwerk' ),
				'vertical-left'       => esc_html__( 'Vertical Left', 'amwerk' ),
				'vertical-right'      => esc_html__( 'Vertical Right', 'amwerk' ),
				'vertical-fullscreen' => esc_html__( 'Vertical Full Screen', 'amwerk' )
			)
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_menu_type' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_menu_type' );

// VERTICAL FULLSCREEN MENU IMAGE BACKGROUND
if ( ! function_exists( 'boldthemes_customize_menu_background' ) ) {
	function boldthemes_customize_menu_background( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[menu_background]', array(
			'default'           => BoldThemes_Customize_Default::$data['menu_background'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_image'
		));
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'menu_background', array(
			'label'    => esc_html__( 'Fullscreen Menu Background Image', 'amwerk' ),
			'description'    => esc_html__( 'Set static image as a vertical fullscreen menu background. Minimum recommended size: 1920x1080px', 'amwerk' ),
			'section'  => BoldThemesFramework::$pfx . '_header_footer_section',
			'settings' => BoldThemesFramework::$pfx . '_theme_options[menu_background]',
			'priority' => 62,
			'context'  => BoldThemesFramework::$pfx . '_menu_background'
		)));
	}
}
add_action( 'customize_register', 'boldthemes_customize_menu_background' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_menu_background' );

// VERTICAL FULLSCREEN MENU IMAGE BACKGROUND OPACITY
if ( ! function_exists( 'boldthemes_customize_menu_background_opacity' ) ) {
	function boldthemes_customize_menu_background_opacity( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[menu_background_opacity]', array(
			'default'           => BoldThemes_Customize_Default::$data['menu_background_opacity'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field'
		));
		$wp_customize->add_control( 'menu_background_opacity', array(
			'label'    => esc_html__( 'Fullscreen Menu Background Opacity', 'amwerk' ),
			'description'    => esc_html__( 'Set opacity for static image which is a vertical fullscreen menu background. Ex. 0.8', 'amwerk' ),
			'section'  => BoldThemesFramework::$pfx . '_header_footer_section',
			'settings' => BoldThemesFramework::$pfx . '_theme_options[menu_background_opacity]',
			'priority' => 62,
			'type'     => 'text'
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_menu_background_opacity' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_menu_background_opacity' );

// SIDEBAR VERTICAL POSITION
if ( ! function_exists( 'boldthemes_customize_sidebar_vertical_position' ) ) {
	function boldthemes_customize_sidebar_vertical_position( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[sidebar_vertical_position]', array(
			'default'           => BoldThemes_Customize_Default::$data['sidebar_vertical_position'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_select'
		));
		$wp_customize->add_control( 'sidebar_vertical_position', array(
			'label'     => esc_html__( 'Sidebar Vertical Position', 'amwerk' ),
			'description'    => esc_html__( 'Set whether you\'d like to have a standard or a bit fancy sidebar, that enters vertically in the default page headline, only if it isn\'t hidden.', 'amwerk' ),
			'section'   => BoldThemesFramework::$pfx . '_sidebar_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[sidebar_vertical_position]',
			'priority'  => 94,
			'type'      => 'select',
			'choices'   => array(
				'standard' => esc_html__( 'Standard', 'amwerk' ),
				'inside'   => esc_html__( 'Inside default headline', 'amwerk' )
			)
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_sidebar_vertical_position' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_sidebar_vertical_position' );


// SIDEBAR STYLE
if ( ! function_exists( 'boldthemes_customize_sidebar_style' ) ) {
	function boldthemes_customize_sidebar_style( $wp_customize ) {
		
		$wp_customize->add_setting( BoldThemesFramework::$pfx . '_theme_options[sidebar_style]', array(
			'default'           => BoldThemes_Customize_Default::$data['sidebar_style'],
			'type'              => 'option',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'boldthemes_sanitize_select'
		));
		$wp_customize->add_control( 'sidebar_style', array(
			'label'     => esc_html__( 'Sidebar Style', 'amwerk' ),
			'description'    => esc_html__( 'Select the sidebar style to make it visually stand out a bit more, if that\'s what you like.', 'amwerk' ),
			'section'   => BoldThemesFramework::$pfx . '_sidebar_section',
			'settings'  => BoldThemesFramework::$pfx . '_theme_options[sidebar_style]',
			'priority'  => 95,
			'type'      => 'select',
			'choices'   => array(
				'standard'		=> esc_html__( 'Standard', 'amwerk' ),
				'accentTopBorder'		=> esc_html__( 'With accent top border', 'amwerk' ),
				'alternateTopBorder'	=> esc_html__( 'With alternate top border', 'amwerk' ),
				'shadedBckgColor'		=> esc_html__( 'With shaded background color', 'amwerk' ),
				'shadow'				=> esc_html__( 'With shadow', 'amwerk' ),
				'thickBordered'			=> esc_html__( 'With a border all around', 'amwerk' )
			)
		));
	}
}
add_action( 'customize_register', 'boldthemes_customize_sidebar_style' );
add_action( 'boldthemes_customize_register', 'boldthemes_customize_sidebar_style' );